/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.advancementannouncer.Handlers;

import io.github.altkat.advancementannouncer.AdvancementAnnouncer;
import java.util.HashMap;
import java.util.Map;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.advancement.Advancement;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AdvancementHandler {
    private final NamespacedKey key;
    private final String icon;
    private final String message;
    private final Style style;
    private final AdvancementAnnouncer plugin = AdvancementAnnouncer.getInstance();
    private static final Map<String, NamespacedKey> cachedKeys = new HashMap<String, NamespacedKey>();

    private AdvancementHandler(String icon, String message, Style style) {
        this.icon = icon;
        this.message = message;
        this.style = style;
        String cacheId = icon.toLowerCase() + "_" + style.toString().toLowerCase() + "_" + Integer.toHexString(message.hashCode());
        if (!cachedKeys.containsKey(cacheId)) {
            this.key = new NamespacedKey((Plugin)this.plugin, "t_" + cacheId);
            this.createAdvancement();
            cachedKeys.put(cacheId, this.key);
        } else {
            this.key = cachedKeys.get(cacheId);
        }
    }

    private void start(Player player) {
        this.revokeAdvancement(player);
        this.grantAdvancement(player);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (player.isOnline()) {
                this.revokeAdvancement(player);
            }
        }, 40L);
    }

    private void createAdvancement() {
        String itemKey = this.plugin.getVersion() <= 20 ? "item" : "id";
        String advancementJson = "{\n    \"criteria\": {\n        \"trigger\": {\n            \"trigger\": \"minecraft:impossible\"\n        }\n    },\n    \"display\": {\n        \"icon\": {\n            \"" + itemKey + "\": \"minecraft:" + this.icon + "\"\n        },\n        \"title\": {\n            \"text\": \"" + this.message.replace("|", "\n") + "\"\n        },\n        \"description\": {\n            \"text\": \"\"\n        },\n        \"background\": \"minecraft:textures/gui/advancements/backgrounds/adventure.png\",\n        \"frame\": \"" + this.style.toString().toLowerCase() + "\",\n        \"announce_to_chat\": false,\n        \"show_toast\": true,\n        \"hidden\": true\n    },\n    \"requirements\": [\n        [\n            \"trigger\"\n        ]\n    ]\n}";
        try {
            Bukkit.getUnsafe().loadAdvancement(this.key, advancementJson);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error creating advancement: " + e.getMessage());
        }
    }

    private void grantAdvancement(Player player) {
        try {
            Advancement adv = Bukkit.getAdvancement((NamespacedKey)this.key);
            if (adv != null) {
                player.getAdvancementProgress(adv).awardCriteria("trigger");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void revokeAdvancement(Player player) {
        try {
            Advancement adv = Bukkit.getAdvancement((NamespacedKey)this.key);
            if (adv != null && player.isOnline()) {
                player.getAdvancementProgress(adv).revokeCriteria("trigger");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void displayTo(Player player, String icon, String message, Style style) {
        String finalMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        if (AdvancementAnnouncer.getInstance().isPAPIEnabled()) {
            finalMessage = PlaceholderAPI.setPlaceholders((Player)player, (String)finalMessage);
        }
        new AdvancementHandler(icon, finalMessage, style).start(player);
    }

    public static enum Style {
        GOAL,
        TASK,
        CHALLENGE;

    }
}

