/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.advancementannouncer.guis;

import io.github.altkat.advancementannouncer.AdvancementAnnouncer;
import io.github.altkat.advancementannouncer.Handlers.AutoAnnounce;
import io.github.altkat.advancementannouncer.Handlers.ChatInputListener;
import io.github.altkat.advancementannouncer.guis.AutoAnnounceGUI;
import io.github.altkat.advancementannouncer.guis.IconSelectionGUI;
import io.github.altkat.advancementannouncer.guis.JoinMessageListGUI;
import io.github.altkat.advancementannouncer.guis.MainMenuGUI;
import io.github.altkat.advancementannouncer.guis.PresetsGUI;
import io.github.altkat.advancementannouncer.guis.StyleSelectionGUI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class EditorGUI {
    private static final AdvancementAnnouncer plugin = AdvancementAnnouncer.getInstance();
    private static final int SLOT_SET_NAME = 10;
    private static final int SLOT_SET_MESSAGE = 13;
    private static final int SLOT_SET_STYLE = 16;
    private static final int SLOT_SET_ICON = 19;
    private static final int SLOT_SAVE = 49;
    private static final int SLOT_CANCEL = 45;

    public static void open(Player player, Map<String, Object> data) {
        String type;
        String readableType;
        boolean isCreator = (Boolean)data.get("isCreator");
        Object title = (isCreator ? "Creating " : "Editing ") + (readableType = (type = (String)data.get("type")).replace("-", " "));
        if (((String)title).length() > 32) {
            title = ((String)title).substring(0, 32);
        }
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)title);
        ChatInputListener.activeSessions.put(player.getUniqueId(), data);
        ItemStack nameItem = new ItemStack(Material.NAME_TAG);
        ItemMeta nameMeta = nameItem.getItemMeta();
        nameMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Set Name");
        ArrayList<Object> nameLore = new ArrayList<Object>();
        nameLore.add(String.valueOf(ChatColor.GRAY) + "Current: " + String.valueOf(data.get("name")));
        nameLore.add(" ");
        nameLore.add(String.valueOf(ChatColor.GREEN) + "Click to change the name via chat.");
        nameMeta.setLore(nameLore);
        nameItem.setItemMeta(nameMeta);
        gui.setItem(10, nameItem);
        ItemStack messageItem = new ItemStack(Material.WRITABLE_BOOK);
        ItemMeta messageMeta = messageItem.getItemMeta();
        messageMeta.setDisplayName(String.valueOf(ChatColor.AQUA) + "Set Message");
        ArrayList<String> messageLore = new ArrayList<String>();
        messageLore.add(String.valueOf(ChatColor.GRAY) + "Current: ");
        EditorGUI.addFormattedMessage(messageLore, (String)data.get("message"));
        messageLore.add(" ");
        messageLore.add(String.valueOf(ChatColor.GREEN) + "Click to change the message via chat.");
        messageMeta.setLore(messageLore);
        messageItem.setItemMeta(messageMeta);
        gui.setItem(13, messageItem);
        if (!type.equals("preset")) {
            Material iconMaterial;
            ItemStack styleItem = new ItemStack(Material.PAINTING);
            ItemMeta styleMeta = styleItem.getItemMeta();
            styleMeta.setDisplayName(String.valueOf(ChatColor.GOLD) + "Set Style");
            ArrayList<Object> styleLore = new ArrayList<Object>();
            styleLore.add(String.valueOf(ChatColor.GRAY) + "Current: " + String.valueOf(data.get("style")));
            styleLore.add(" ");
            styleLore.add(String.valueOf(ChatColor.GREEN) + "Click to choose a style.");
            styleMeta.setLore(styleLore);
            styleItem.setItemMeta(styleMeta);
            gui.setItem(16, styleItem);
            try {
                iconMaterial = Material.valueOf((String)((String)data.get("icon")).toUpperCase());
            }
            catch (Exception e) {
                iconMaterial = Material.STONE;
            }
            ItemStack iconItem = new ItemStack(iconMaterial);
            ItemMeta iconMeta = iconItem.getItemMeta();
            iconMeta.setDisplayName(String.valueOf(ChatColor.LIGHT_PURPLE) + "Set Icon");
            ArrayList<Object> iconLore = new ArrayList<Object>();
            iconLore.add(String.valueOf(ChatColor.GRAY) + "Current: " + String.valueOf(data.get("icon")));
            iconLore.add(" ");
            iconLore.add(String.valueOf(ChatColor.GREEN) + "Click to choose an icon.");
            iconMeta.setLore(iconLore);
            iconItem.setItemMeta(iconMeta);
            gui.setItem(19, iconItem);
        }
        ItemStack saveItem = new ItemStack(Material.GREEN_WOOL);
        ItemMeta saveMeta = saveItem.getItemMeta();
        saveMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Save");
        saveItem.setItemMeta(saveMeta);
        gui.setItem(49, saveItem);
        ItemStack backItem = new ItemStack(Material.BARRIER);
        ItemMeta backMeta = backItem.getItemMeta();
        backMeta.setDisplayName(String.valueOf(ChatColor.RED) + "Cancel");
        backItem.setItemMeta(backMeta);
        gui.setItem(45, backItem);
        player.openInventory(gui);
    }

    public static void handleClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        Map<String, Object> data = ChatInputListener.activeSessions.get(player.getUniqueId());
        if (data == null) {
            player.closeInventory();
            return;
        }
        switch (event.getSlot()) {
            case 10: {
                player.closeInventory();
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Please type the new name in chat. (Type 'cancel' to abort)");
                player.sendMessage(String.valueOf(ChatColor.GRAY) + "Current value: " + String.valueOf(data.get("name")));
                data.put("step", "name");
                break;
            }
            case 13: {
                player.closeInventory();
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Please type the new message in chat. (Use | for new line, type 'cancel' to abort)");
                player.sendMessage(String.valueOf(ChatColor.GRAY) + "Current value: " + String.valueOf(data.get("message")));
                data.put("step", "message");
                break;
            }
            case 16: {
                StyleSelectionGUI.open(player);
                break;
            }
            case 19: {
                IconSelectionGUI.open(player, 0);
                break;
            }
            case 49: {
                EditorGUI.saveChanges(player, data);
                break;
            }
            case 45: {
                ChatInputListener.activeSessions.remove(player.getUniqueId());
                EditorGUI.returnToPreviousMenu(player, (String)data.get("type"));
            }
        }
    }

    private static void returnToPreviousMenu(Player player, String type) {
        switch (type) {
            case "preset": {
                PresetsGUI.open(player);
                break;
            }
            case "auto-announce": {
                AutoAnnounceGUI.open(player);
                break;
            }
            case "join-message": {
                JoinMessageListGUI.open(player, "join");
                break;
            }
            case "first-join-message": {
                JoinMessageListGUI.open(player, "first-join");
                break;
            }
            default: {
                MainMenuGUI.open(player);
            }
        }
    }

    private static void saveChanges(Player player, Map<String, Object> data) {
        String basePath;
        String name = (String)data.get("name");
        if (name == null || name.isBlank() || name.equals("<not set>")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You must set a name before saving!");
            return;
        }
        boolean isCreator = (Boolean)data.get("isCreator");
        String type = (String)data.get("type");
        String originalName = (String)data.get("originalName");
        switch (type) {
            case "preset": {
                basePath = "presets.";
                break;
            }
            case "auto-announce": {
                basePath = "auto-announce.messages.";
                break;
            }
            case "join-message": {
                basePath = "join-features.join-messages.messages.";
                break;
            }
            case "first-join-message": {
                basePath = "join-features.first-join-messages.messages.";
                break;
            }
            default: {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Error: Unknown data type.");
                return;
            }
        }
        if (!isCreator && originalName != null && !originalName.equals(name)) {
            plugin.getConfig().set(basePath + originalName, null);
        }
        if (plugin.getConfig().contains(basePath + name) && (isCreator || !originalName.equals(name))) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "An item with this name already exists!");
            return;
        }
        ChatInputListener.activeSessions.remove(player.getUniqueId());
        if (type.equals("preset")) {
            plugin.getConfig().set(basePath + name, data.get("message"));
        } else {
            plugin.getConfig().set(basePath + name + ".message", data.get("message"));
            plugin.getConfig().set(basePath + name + ".style", data.get("style"));
            plugin.getConfig().set(basePath + name + ".icon", data.get("icon"));
        }
        plugin.saveConfig();
        if (type.equals("auto-announce")) {
            AutoAnnounce.stopAutoAnnounce();
            AutoAnnounce.startAutoAnnounce();
        }
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Changes saved successfully!");
        EditorGUI.returnToPreviousMenu(player, type);
    }

    private static void addFormattedMessage(List<String> lore, String message) {
        if (message != null && message.contains("|")) {
            for (String line : message.split("\\|")) {
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
            }
        } else if (message != null) {
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        }
    }
}

