/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.advancementannouncer.guis;

import io.github.altkat.advancementannouncer.AdvancementAnnouncer;
import io.github.altkat.advancementannouncer.Handlers.AutoAnnounce;
import io.github.altkat.advancementannouncer.Handlers.ChatInputListener;
import io.github.altkat.advancementannouncer.Handlers.GUIHandler;
import io.github.altkat.advancementannouncer.guis.ConfirmationGUI;
import io.github.altkat.advancementannouncer.guis.EditorGUI;
import io.github.altkat.advancementannouncer.guis.MainMenuGUI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AutoAnnounceGUI {
    private static final AdvancementAnnouncer plugin = AdvancementAnnouncer.getInstance();
    private static final int SLOT_AA_TOGGLE = 48;
    private static final int SLOT_AA_INTERVAL = 49;
    private static final int SLOT_AA_MODE = 50;
    private static final int SLOT_ADD_ITEM = 53;
    private static final int SLOT_BACK_BUTTON = 45;

    public static void open(Player player) {
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)plugin.getConfig().getString("lang-messages.auto-announce-gui-title")));
        ConfigurationSection aaSection = plugin.getConfig().getConfigurationSection("auto-announce");
        ItemStack enabledItem = new ItemStack(aaSection.getBoolean("enabled") ? Material.LIME_DYE : Material.GRAY_DYE);
        ItemMeta enabledMeta = enabledItem.getItemMeta();
        enabledMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Auto Announce: " + (aaSection.getBoolean("enabled") ? String.valueOf(ChatColor.GREEN) + "Enabled" : String.valueOf(ChatColor.RED) + "Disabled"));
        enabledItem.setItemMeta(enabledMeta);
        gui.setItem(48, enabledItem);
        ItemStack intervalItem = new ItemStack(Material.CLOCK);
        ItemMeta intervalMeta = intervalItem.getItemMeta();
        intervalMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Interval: " + String.valueOf(ChatColor.GOLD) + aaSection.getInt("interval") + "s");
        intervalItem.setItemMeta(intervalMeta);
        gui.setItem(49, intervalItem);
        ItemStack modeItem = new ItemStack(Material.COMPARATOR);
        ItemMeta modeMeta = modeItem.getItemMeta();
        modeMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Mode: " + String.valueOf(ChatColor.GOLD) + aaSection.getString("mode"));
        modeItem.setItemMeta(modeMeta);
        gui.setItem(50, modeItem);
        ConfigurationSection messagesSection = aaSection.getConfigurationSection("messages");
        if (messagesSection != null) {
            for (String key : messagesSection.getKeys(false)) {
                Material iconMaterial;
                try {
                    iconMaterial = Material.valueOf((String)messagesSection.getString(key + ".icon").toUpperCase());
                }
                catch (IllegalArgumentException | NullPointerException e) {
                    iconMaterial = Material.PAPER;
                }
                ItemStack item = new ItemStack(iconMaterial);
                ItemMeta meta = item.getItemMeta();
                meta.setDisplayName(String.valueOf(ChatColor.GREEN) + key);
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(String.valueOf(ChatColor.WHITE) + "Message: ");
                AutoAnnounceGUI.addFormattedMessage(lore, messagesSection.getString(key + ".message"));
                lore.add(" ");
                lore.add(String.valueOf(ChatColor.WHITE) + "Style: " + messagesSection.getString(key + ".style"));
                lore.add(String.valueOf(ChatColor.WHITE) + "Icon: " + messagesSection.getString(key + ".icon"));
                lore.add(" ");
                lore.add(String.valueOf(ChatColor.YELLOW) + "Left click to edit.");
                lore.add(String.valueOf(ChatColor.RED) + "Right click to delete.");
                meta.setLore(lore);
                item.setItemMeta(meta);
                gui.addItem(new ItemStack[]{item});
            }
        }
        ItemStack backItem = new ItemStack(Material.BARRIER);
        ItemMeta backMeta = backItem.getItemMeta();
        backMeta.setDisplayName(String.valueOf(ChatColor.RED) + "Back");
        backItem.setItemMeta(backMeta);
        gui.setItem(45, backItem);
        ItemStack addItem = new ItemStack(Material.EMERALD);
        ItemMeta addMeta = addItem.getItemMeta();
        addMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Add Message");
        addItem.setItemMeta(addMeta);
        gui.setItem(53, addItem);
        player.openInventory(gui);
    }

    public static void handleClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        int slot = event.getSlot();
        if (slot == 45) {
            MainMenuGUI.open(player);
            return;
        }
        switch (slot) {
            case 48: {
                boolean currentStatus = plugin.getConfig().getBoolean("auto-announce.enabled");
                plugin.getConfig().set("auto-announce.enabled", (Object)(!currentStatus ? 1 : 0));
                plugin.saveConfig();
                AutoAnnounce.stopAutoAnnounce();
                AutoAnnounce.startAutoAnnounce();
                AutoAnnounceGUI.open(player);
                break;
            }
            case 49: {
                player.closeInventory();
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Please type the new interval (in seconds) in chat.");
                player.sendMessage(String.valueOf(ChatColor.GRAY) + "Current: " + plugin.getConfig().getInt("auto-announce.interval"));
                player.sendMessage(String.valueOf(ChatColor.GRAY) + "(Type 'cancel' to exit)");
                ChatInputListener.activeSessions.put(player.getUniqueId(), (Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("step", "interval");
                    }
                });
                break;
            }
            case 50: {
                String currentMode = plugin.getConfig().getString("auto-announce.mode");
                String newMode = currentMode.equalsIgnoreCase("ORDERED") ? "RANDOM" : "ORDERED";
                plugin.getConfig().set("auto-announce.mode", (Object)newMode);
                plugin.saveConfig();
                AutoAnnounce.stopAutoAnnounce();
                AutoAnnounce.startAutoAnnounce();
                AutoAnnounceGUI.open(player);
                break;
            }
            case 53: {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("isCreator", true);
                data.put("type", "auto-announce");
                data.put("name", "<not set>");
                data.put("message", "Default message");
                data.put("style", "GOAL");
                data.put("icon", "STONE");
                EditorGUI.open(player, data);
                break;
            }
            default: {
                if (event.getCurrentItem() == null || event.getCurrentItem().getItemMeta() == null || slot >= 45) break;
                String messageName = ChatColor.stripColor((String)event.getCurrentItem().getItemMeta().getDisplayName());
                if (event.isRightClick()) {
                    ConfirmationGUI.open(player, messageName);
                    GUIHandler.confirmationActions.put(player.getUniqueId(), () -> {
                        plugin.getConfig().set("auto-announce.messages." + messageName, null);
                        plugin.saveConfig();
                        AutoAnnounce.stopAutoAnnounce();
                        AutoAnnounce.startAutoAnnounce();
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Auto-announce message '" + messageName + "' has been deleted.");
                        AutoAnnounceGUI.open(player);
                    });
                    break;
                }
                if (!event.isLeftClick()) break;
                HashMap<String, Object> editData = new HashMap<String, Object>();
                String path = "auto-announce.messages." + messageName;
                editData.put("isCreator", false);
                editData.put("originalName", messageName);
                editData.put("type", "auto-announce");
                editData.put("name", messageName);
                editData.put("message", plugin.getConfig().getString(path + ".message", ""));
                editData.put("style", plugin.getConfig().getString(path + ".style", "GOAL"));
                editData.put("icon", plugin.getConfig().getString(path + ".icon", "STONE"));
                EditorGUI.open(player, editData);
            }
        }
    }

    private static void addFormattedMessage(List<String> lore, String message) {
        if (message != null && message.contains("|")) {
            for (String line : message.split("\\|")) {
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
            }
        } else if (message != null) {
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        }
    }
}

