/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.advancementannouncer;

import io.github.altkat.advancementannouncer.Handlers.AutoAnnounce;
import io.github.altkat.advancementannouncer.Handlers.ChatInputListener;
import io.github.altkat.advancementannouncer.Handlers.CommandHandler;
import io.github.altkat.advancementannouncer.Handlers.ConfigUpdater;
import io.github.altkat.advancementannouncer.Handlers.GUIHandler;
import io.github.altkat.advancementannouncer.Handlers.JoinListener;
import io.github.altkat.advancementannouncer.Handlers.UpdateChecker;
import io.github.altkat.advancementannouncer.PlayerData;
import io.github.altkat.advancementannouncer.bukkit.Metrics;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AdvancementAnnouncer
extends JavaPlugin {
    boolean IsPAPIEnabled;
    int version;

    public void onEnable() {
        String bukkitVersion = Bukkit.getServer().getBukkitVersion();
        String versionString = bukkitVersion.split("\\-")[0];
        String[] versions = versionString.split("\\.");
        this.version = Integer.parseInt(versions[1]);
        if (this.version < 16) {
            this.getLogger().severe("This plugin is only compatible with 1.16 and above!");
            this.getServer().getConsoleSender().sendMessage("\u00a73[AdvancementAnnouncer] \u00a7cThis plugin is only compatible with 1.16 and above!, disabling plugin...");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.IsPAPIEnabled = true;
            this.getServer().getConsoleSender().sendMessage("\u00a73[AdvancementAnnouncer] \u00a7aPlaceholderAPI found! Enabling placeholder support...");
        }
        this.updateConfig();
        new PlayerData(this);
        CommandHandler commandHandler = new CommandHandler();
        this.getCommand("advancementannouncer").setExecutor((CommandExecutor)commandHandler);
        this.getCommand("advancementannouncer").setTabCompleter((TabCompleter)commandHandler);
        this.getServer().getPluginManager().registerEvents((Listener)new GUIHandler(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatInputListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new JoinListener(), (Plugin)this);
        AutoAnnounce.startAutoAnnounce();
        int pluginId = 24282;
        new Metrics(this, pluginId);
        new UpdateChecker(this, "altkat/AdvancementAnnouncer").checkAsync();
        this.getServer().getConsoleSender().sendMessage("\u00a73[AdvancementAnnouncer] \u00a7aPlugin has been enabled!");
    }

    private void updateConfig() {
        this.saveDefaultConfig();
        try {
            ConfigUpdater.update(this);
            this.reloadConfig();
        }
        catch (IOException e) {
            this.getLogger().severe("Could not update config.yml!");
            e.printStackTrace();
        }
    }

    public void onDisable() {
        this.getServer().getConsoleSender().sendMessage("\u00a73[AdvancementAnnouncer] \u00a7cPlugin has been disabled!");
    }

    public static AdvancementAnnouncer getInstance() {
        return (AdvancementAnnouncer)AdvancementAnnouncer.getPlugin(AdvancementAnnouncer.class);
    }

    public boolean isPAPIEnabled() {
        return this.IsPAPIEnabled;
    }

    public int getVersion() {
        return this.version;
    }
}

