/*
 * Decompiled with CFR 0.152.
 */
package dev.rollczi.litecommands.strict;

import dev.rollczi.litecommands.meta.Meta;
import dev.rollczi.litecommands.meta.MetaHolder;
import dev.rollczi.litecommands.shared.Preconditions;
import dev.rollczi.litecommands.strict.StrictMode;

public class StrictService {
    private StrictMode defaultMode = StrictMode.ENABLED;

    public void setDefaultMode(StrictMode defaultMode) {
        Preconditions.notNull((Object)defaultMode, "defaultMode");
        Preconditions.checkArgument(defaultMode != StrictMode.DEFAULT, "Default mode cannot be DEFAULT", new Object[0]);
        this.defaultMode = defaultMode;
    }

    public StrictMode getDefaultMode() {
        return this.defaultMode;
    }

    public boolean isStrict(MetaHolder metaHolder) {
        StrictMode first = metaHolder.metaCollector().findFirst(Meta.STRICT_MODE);
        switch (first) {
            case ENABLED: {
                return true;
            }
            case DISABLED: {
                return false;
            }
        }
        return this.defaultMode == StrictMode.ENABLED;
    }
}

