/*
 * Decompiled with CFR 0.152.
 */
package dev.rollczi.litecommands.shared;

import dev.rollczi.litecommands.shared.AttemptFailedException;
import java.util.function.Supplier;

public class Lazy<T>
implements Supplier<T> {
    private Supplier<T> supplier;
    private boolean initialized;
    private T value;
    private Exception exception;

    public Lazy(T value) {
        this.initialized = true;
        this.value = value;
    }

    public Lazy(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public static Lazy<Void> ofRunnable(Runnable runnable) {
        return new Lazy<Void>(() -> {
            runnable.run();
            return null;
        });
    }

    @Override
    public synchronized T get() {
        if (this.exception != null) {
            throw new AttemptFailedException("Lazy value has been already initialized with exception", this.exception);
        }
        if (this.initialized) {
            return this.value;
        }
        this.initialized = true;
        try {
            this.value = this.supplier.get();
            return this.value;
        }
        catch (Exception exception) {
            this.exception = exception;
            throw new AttemptFailedException("Cannot initialize lazy value", exception);
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean hasFailed() {
        return this.exception != null;
    }
}

