/*
 * Decompiled with CFR 0.152.
 */
package dev.rollczi.litecommands.requirement;

import dev.rollczi.litecommands.argument.Argument;
import dev.rollczi.litecommands.argument.parser.ParseResult;
import dev.rollczi.litecommands.argument.parser.ParserRegistry;
import dev.rollczi.litecommands.argument.parser.input.ParseableInputMatcher;
import dev.rollczi.litecommands.bind.BindRegistry;
import dev.rollczi.litecommands.bind.BindRequirement;
import dev.rollczi.litecommands.bind.BindResult;
import dev.rollczi.litecommands.command.executor.CommandExecutor;
import dev.rollczi.litecommands.context.ContextRegistry;
import dev.rollczi.litecommands.context.ContextRequirement;
import dev.rollczi.litecommands.invocation.Invocation;
import dev.rollczi.litecommands.meta.Meta;
import dev.rollczi.litecommands.requirement.Requirement;
import dev.rollczi.litecommands.requirement.RequirementFutureResult;
import dev.rollczi.litecommands.requirement.ScheduledRequirement;
import dev.rollczi.litecommands.scheduler.Scheduler;
import dev.rollczi.litecommands.shared.ThrowingSupplier;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ScheduledRequirementResolver<SENDER> {
    private final ContextRegistry<SENDER> contextRegistry;
    private final ParserRegistry<SENDER> parserRegistry;
    private final BindRegistry bindRegistry;
    private final Scheduler scheduler;

    ScheduledRequirementResolver(ContextRegistry<SENDER> contextRegistry, ParserRegistry<SENDER> parserRegistry, BindRegistry bindRegistry, Scheduler scheduler) {
        this.contextRegistry = contextRegistry;
        this.parserRegistry = parserRegistry;
        this.bindRegistry = bindRegistry;
        this.scheduler = scheduler;
    }

    @NotNull
    <MATCHER extends ParseableInputMatcher<MATCHER>> List<ScheduledRequirement<?>> prepareRequirements(CommandExecutor<SENDER> executor, Invocation<SENDER> invocation, MATCHER matcher) {
        ArrayList requirements = new ArrayList();
        for (Argument<?> argument : executor.getArguments()) {
            requirements.add(this.toScheduled(argument, () -> this.matchArgument(argument, invocation, matcher)));
        }
        for (ContextRequirement contextRequirement : executor.getContextRequirements()) {
            requirements.add(this.toScheduled(contextRequirement, () -> this.matchContext(contextRequirement, invocation)));
        }
        for (BindRequirement bindRequirement : executor.getBindRequirements()) {
            requirements.add(this.toScheduled(bindRequirement, () -> this.matchBind(bindRequirement)));
        }
        return requirements;
    }

    private ScheduledRequirement<?> toScheduled(Requirement<?> requirement, ThrowingSupplier<RequirementFutureResult<?>, Throwable> resultSupplier) {
        return new ScheduledRequirement(requirement, () -> this.scheduler.supply(requirement.meta().get(Meta.POLL_TYPE), resultSupplier));
    }

    private <T, MATCHER extends ParseableInputMatcher<MATCHER>> RequirementFutureResult<T> matchArgument(Argument<T> argument, Invocation<SENDER> invocation, MATCHER matcher) {
        return matcher.nextArgument(invocation, argument, () -> this.parserRegistry.getParser(argument));
    }

    private <T> RequirementFutureResult<T> matchContext(ContextRequirement<T> contextRequirement, Invocation<SENDER> invocation) {
        return this.contextRegistry.provideContext(contextRequirement.getType().getRawType(), invocation);
    }

    private <T> RequirementFutureResult<?> matchBind(BindRequirement<T> bindRequirement) {
        Class rawType = bindRequirement.getType().getRawType();
        BindResult instance = this.bindRegistry.getInstance(rawType);
        if (instance.isOk()) {
            return ParseResult.success(instance.getSuccess());
        }
        return ParseResult.failure(instance.getError());
    }
}

