/*
 * Decompiled with CFR 0.152.
 */
package dev.rollczi.litecommands.prettyprint;

import dev.rollczi.litecommands.prettyprint.PrettyPrintAnnotation;
import dev.rollczi.litecommands.prettyprint.PrettyPrintType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.WeakHashMap;

public final class PrettyPrintParameter {
    private static final String PARAMETER_PATTERN = "{annotations}{type} {name}";
    private static final Map<Parameter, Annotation[]> parameterAnnotationsCache = new WeakHashMap<Parameter, Annotation[]>();

    static List<String> formatParameters(Parameter[] parameters) {
        ArrayList<String> list = new ArrayList<String>();
        for (Parameter parameter : parameters) {
            list.add(PrettyPrintParameter.formatParameter(parameter));
        }
        return list;
    }

    static String formatParameters(List<String> formatParameters) {
        StringJoiner joiner = new StringJoiner(", ");
        for (String parameter : formatParameters) {
            joiner.add(parameter);
        }
        return joiner.toString();
    }

    static int getParameterIndex(Executable method, Parameter parameter) {
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].equals(parameter)) continue;
            return i;
        }
        return -1;
    }

    public static String formatParameter(Parameter parameter) {
        Annotation[] parameterAnnotations = parameterAnnotationsCache.computeIfAbsent(parameter, key -> parameter.getAnnotations());
        String annotations = PrettyPrintAnnotation.formatAnnotations(parameterAnnotations, ", ", " ");
        String type = PrettyPrintType.formatType(parameter.getParameterizedType());
        String name = parameter.getName();
        return PARAMETER_PATTERN.replace("{annotations}", annotations).replace("{type}", type).replace("{name}", name);
    }
}

