/*
 * Decompiled with CFR 0.152.
 */
package dev.rollczi.litecommands.permission;

import dev.rollczi.litecommands.meta.MetaHolder;
import dev.rollczi.litecommands.shared.Preconditions;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;

public interface PermissionValidationResult {
    @ApiStatus.Experimental
    public List<Verdict> getVerdicts();

    default public boolean isPermitted() {
        for (Verdict verdict : this.getVerdicts()) {
            if (verdict.isPermitted()) continue;
            return false;
        }
        return true;
    }

    @ApiStatus.Experimental
    public static class Check {
        private final List<String> checkedPermissions;
        private final List<String> missingPermissions;

        Check(List<String> checkedPermissions, List<String> missingPermissions) {
            this.checkedPermissions = checkedPermissions;
            this.missingPermissions = missingPermissions;
        }

        public List<String> getCheckedPermissions() {
            return this.checkedPermissions;
        }

        public List<String> getMissingPermissions() {
            return this.missingPermissions;
        }
    }

    @ApiStatus.Experimental
    public static final class Verdict {
        private final MetaHolder owner;
        private final List<Check> checks;

        Verdict(MetaHolder owner, List<Check> checks) {
            Preconditions.notNull(owner, "owner");
            this.owner = owner;
            this.checks = checks;
        }

        public MetaHolder getOwner() {
            return this.owner;
        }

        public List<Check> getChecks() {
            return this.checks;
        }

        public boolean isPermitted() {
            if (this.checks.isEmpty()) {
                return true;
            }
            for (Check check : this.checks) {
                if (!check.missingPermissions.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public static Verdict permitted(MetaHolder current) {
            return new Verdict(current, Collections.emptyList());
        }
    }
}

