/*
 * Decompiled with CFR 0.152.
 */
package dev.rollczi.litecommands.bukkit;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import dev.rollczi.litecommands.bukkit.BukkitCommand;
import dev.rollczi.litecommands.bukkit.TabCompleteSync;
import dev.rollczi.litecommands.input.raw.RawCommand;
import dev.rollczi.litecommands.scheduler.Scheduler;
import dev.rollczi.litecommands.scheduler.SchedulerType;
import dev.rollczi.litecommands.suggestion.Suggestion;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

class TabCompleteProtocolLibAsync
extends TabCompleteSync {
    private static final ProtocolManager MANAGER = ProtocolLibrary.getProtocolManager();
    private final Scheduler scheduler;
    private PacketAdapter listener;

    TabCompleteProtocolLibAsync(Plugin plugin, Scheduler scheduler) {
        this.scheduler = scheduler;
        this.listener = new PacketAdapter(plugin, new PacketType[]{PacketType.Play.Client.TAB_COMPLETE}){

            public void onPacketReceiving(PacketEvent event) {
                TabCompleteProtocolLibAsync.this.handlePacket(event);
            }
        };
        MANAGER.addPacketListener((PacketListener)this.listener);
    }

    private void handlePacket(PacketEvent event) {
        Player player = event.getPlayer();
        String buffer = (String)event.getPacket().getStrings().read(0);
        if (!buffer.startsWith("/")) {
            return;
        }
        RawCommand rawCommand = RawCommand.from(buffer);
        String commandName = rawCommand.getLabel();
        BukkitCommand command = (BukkitCommand)((Object)this.listeners.get(commandName));
        if (command == null) {
            return;
        }
        event.setCancelled(true);
        this.scheduler.run(SchedulerType.SUGGESTER, () -> {
            try {
                Set<Suggestion> suggestions = command.suggest((CommandSender)player, commandName, rawCommand.getArgs().toArray(new String[0])).get(15L, TimeUnit.SECONDS);
                if (suggestions == null) {
                    return;
                }
                String[] list = (String[])suggestions.stream().map(c -> c.multilevel()).toArray(String[]::new);
                PacketContainer packet = MANAGER.createPacket(PacketType.Play.Server.TAB_COMPLETE);
                packet.getStringArrays().write(0, (Object)list);
                MANAGER.sendServerPacket(player, packet);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void close() {
        super.close();
        if (this.listener != null) {
            ProtocolLibrary.getProtocolManager().removePacketListener((PacketListener)this.listener);
            this.listener = null;
        }
    }
}

