/*
 * Decompiled with CFR 0.152.
 */
package dev.rollczi.litecommands.argument.parser.input;

import dev.rollczi.litecommands.argument.Argument;
import dev.rollczi.litecommands.argument.parser.ParseResult;
import dev.rollczi.litecommands.argument.parser.Parser;
import dev.rollczi.litecommands.argument.parser.input.ParseableInput;
import dev.rollczi.litecommands.argument.parser.input.ParseableInputMatcher;
import dev.rollczi.litecommands.input.raw.RawInput;
import dev.rollczi.litecommands.invalidusage.InvalidUsage;
import dev.rollczi.litecommands.invocation.Invocation;
import dev.rollczi.litecommands.priority.PriorityLevel;
import dev.rollczi.litecommands.shared.FailedReason;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

class NamedParseableInput
implements ParseableInput<NamedParseableInputMatcher> {
    private final List<String> routes = new ArrayList<String>();
    private final Map<String, String> namedArguments = new LinkedHashMap<String, String>();

    NamedParseableInput(List<String> routes, Map<String, String> namedArguments) {
        this.routes.addAll(routes);
        this.namedArguments.putAll(namedArguments);
    }

    @Override
    public NamedParseableInputMatcher createMatcher() {
        return new NamedParseableInputMatcher();
    }

    @Override
    public List<String> asList() {
        ArrayList rawArgs = new ArrayList();
        this.namedArguments.forEach((name, value) -> {
            rawArgs.add(name);
            rawArgs.add(value);
        });
        return Collections.unmodifiableList(rawArgs);
    }

    public class NamedParseableInputMatcher
    implements ParseableInputMatcher<NamedParseableInputMatcher> {
        private final List<String> consumedArguments = new ArrayList<String>();
        private int routePosition = 0;

        public NamedParseableInputMatcher() {
        }

        public NamedParseableInputMatcher(int routePosition) {
            this.routePosition = routePosition;
        }

        @Override
        public <SENDER, PARSED> ParseResult<PARSED> nextArgument(Invocation<SENDER> invocation, Argument<PARSED> argument, Supplier<Parser<SENDER, PARSED>> parserProvider) {
            String input = (String)NamedParseableInput.this.namedArguments.get(argument.getName());
            if (input == null) {
                return ParseResult.failure((Object)InvalidUsage.Cause.MISSING_ARGUMENT);
            }
            this.consumedArguments.add(argument.getName());
            Parser<SENDER, PARSED> parser = parserProvider.get();
            return parser.parse(invocation, argument, RawInput.of(input.split(" ")));
        }

        @Override
        public boolean hasNextRoute() {
            return this.routePosition < NamedParseableInput.this.routes.size();
        }

        @Override
        public String showNextRoute() {
            return (String)NamedParseableInput.this.routes.get(this.routePosition);
        }

        @Override
        public String nextRoute() {
            return (String)NamedParseableInput.this.routes.get(this.routePosition++);
        }

        @Override
        public NamedParseableInputMatcher copy() {
            return new NamedParseableInputMatcher(this.routePosition);
        }

        @Override
        public ParseableInputMatcher.EndResult endMatch(boolean isStrict) {
            if (this.consumedArguments.size() < NamedParseableInput.this.namedArguments.size() && isStrict) {
                return ParseableInputMatcher.EndResult.failed(FailedReason.of((Object)InvalidUsage.Cause.TOO_MANY_ARGUMENTS, PriorityLevel.LOW));
            }
            return ParseableInputMatcher.EndResult.success();
        }
    }
}

