/*
 * Decompiled with CFR 0.152.
 */
package dev.rollczi.litecommands.annotations.requirement;

import dev.rollczi.litecommands.annotations.AnnotationInvoker;
import dev.rollczi.litecommands.annotations.AnnotationProcessor;
import dev.rollczi.litecommands.annotations.MethodInvoker;
import dev.rollczi.litecommands.annotations.requirement.RequirementDefinition;
import dev.rollczi.litecommands.argument.Argument;
import dev.rollczi.litecommands.bind.BindRequirement;
import dev.rollczi.litecommands.context.ContextRequirement;
import dev.rollczi.litecommands.reflect.LiteCommandsReflectException;
import dev.rollczi.litecommands.reflect.type.TypeToken;
import dev.rollczi.litecommands.requirement.Requirement;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class RequirementDefinitionProcessor<SENDER>
implements AnnotationProcessor<SENDER> {
    @Override
    public AnnotationInvoker<SENDER> process(AnnotationInvoker<SENDER> invoker) {
        if (!(invoker instanceof MethodInvoker)) {
            return invoker;
        }
        MethodInvoker methodInvoker = (MethodInvoker)invoker;
        return methodInvoker.mapParameter((parameter, annotation) -> {
            RequirementDefinition definition = annotation.annotationType().getAnnotation(RequirementDefinition.class);
            if (definition == null) {
                return Optional.empty();
            }
            return Optional.of(this.createRequirement(definition, (Parameter)parameter, (Annotation)annotation));
        });
    }

    private Requirement<?> createRequirement(RequirementDefinition definition, Parameter parameter, Annotation annotation) {
        String name = this.getName(definition, parameter, annotation);
        TypeToken type = TypeToken.ofParameter(parameter);
        switch (definition.type()) {
            case ARGUMENT: {
                return Argument.of(name, type);
            }
            case CONTEXT: {
                return ContextRequirement.of(() -> name, type);
            }
            case BIND: {
                return BindRequirement.of(() -> name, type);
            }
        }
        throw new IllegalArgumentException("Unknown requirement type: " + (Object)((Object)definition.type()));
    }

    private String getName(RequirementDefinition definition, Parameter parameter, Annotation annotation) {
        for (String attributeName : definition.nameProviders()) {
            try {
                Method attributeMethod = annotation.annotationType().getDeclaredMethod(attributeName, new Class[0]);
                String nameCandidate = RequirementDefinitionProcessor.getPrimaryName(annotation, attributeName, attributeMethod);
                if (nameCandidate.isEmpty()) continue;
                return nameCandidate;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exception) {
                throw new LiteCommandsReflectException("Cannot find method " + attributeName + " in annotation " + annotation.annotationType().getSimpleName(), exception);
            }
        }
        return parameter.getName();
    }

    @NotNull
    private static String getPrimaryName(Annotation annotation, String attributeName, Method attributeMethod) throws IllegalAccessException, InvocationTargetException {
        Object object = attributeMethod.invoke((Object)annotation, new Object[0]);
        if (object instanceof String[]) {
            String[] array = (String[])object;
            if (array.length == 0) {
                return "";
            }
            return array[0];
        }
        if (object instanceof String) {
            return (String)object;
        }
        throw new LiteCommandsReflectException("Attribute " + attributeName + " in annotation " + annotation.annotationType().getSimpleName() + " must return a String");
    }
}

