/*
 * Decompiled with CFR 0.152.
 */
package de.exlll.configlib;

import de.exlll.configlib.ConfigurationElement;
import de.exlll.configlib.ConfigurationElements;
import de.exlll.configlib.ConfigurationException;
import de.exlll.configlib.ConfigurationProperties;
import de.exlll.configlib.ConfigurationSerializer;
import de.exlll.configlib.NameFormatter;
import de.exlll.configlib.PostProcess;
import de.exlll.configlib.Reflect;
import de.exlll.configlib.Serializer;
import de.exlll.configlib.SerializerSelector;
import de.exlll.configlib.Validator;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

abstract class TypeSerializer<T, E extends ConfigurationElement<?>>
implements Serializer<T, Map<?, ?>> {
    protected final Class<T> type;
    protected final ConfigurationProperties properties;
    protected final NameFormatter formatter;
    protected final Map<String, Serializer<?, ?>> serializers;
    protected final UnaryOperator<T> postProcessor;

    protected TypeSerializer(Class<T> type, ConfigurationProperties properties) {
        this.type = Validator.requireNonNull(type, "type");
        this.properties = Validator.requireNonNull(properties, "configuration properties");
        this.formatter = properties.getNameFormatter();
        this.serializers = this.buildSerializerMap();
        this.postProcessor = this.createPostProcessorFromAnnotatedMethod();
        this.requireSerializableElements();
    }

    static <T> TypeSerializer<T, ?> newSerializerFor(Class<T> type, ConfigurationProperties properties) {
        return new ConfigurationSerializer<T>(type, properties);
    }

    Map<String, Serializer<?, ?>> buildSerializerMap() {
        SerializerSelector selector = new SerializerSelector(this.properties);
        try {
            return this.elements().stream().collect(Collectors.toMap(ConfigurationElement::name, selector::select));
        }
        catch (StackOverflowError error) {
            String msg = "Recursive type definitions are not supported.";
            throw new ConfigurationException(msg, error);
        }
    }

    @Override
    public final Map<?, ?> serialize(T configuration) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (ConfigurationElement element : this.elements()) {
            Object elementValue = element.value(configuration);
            if (elementValue == null && !this.properties.outputNulls()) continue;
            Object serializedValue = this.serializeElement(element, elementValue);
            String formattedName = this.formatter.format(element.name());
            result.put(formattedName, serializedValue);
        }
        return result;
    }

    protected final Object serializeElement(E element, Object value) {
        if (value == null) {
            return null;
        }
        Serializer<?, ?> serializer = this.serializers.get(element.name());
        try {
            Object serialized = serializer.serialize(value);
            TypeSerializer.validateTargetType(element, value, serialized);
            return serialized;
        }
        catch (ClassCastException e) {
            String msg = String.format("Serialization of value '%s' for element '%s' of type '%s' failed.\nThe type of the object to be serialized does not match the type the custom serializer of type '%s' expects.", value, element.element(), element.declaringType(), serializer.getClass());
            throw new ConfigurationException(msg, e);
        }
    }

    private static void validateTargetType(ConfigurationElement<?> element, Object value, Object serialized) {
        try {
            Validator.requireTargetType(serialized);
        }
        catch (ConfigurationException e) {
            String msg = String.format("Serialization of value '%s' for element '%s' of type '%s' failed. The serializer produced an invalid target type.", value, element.element(), element.declaringType());
            throw new ConfigurationException(msg, e);
        }
    }

    protected final Object deserialize(E element, Object value) {
        Object deserialized;
        Serializer<?, ?> serializer = this.serializers.get(element.name());
        try {
            deserialized = serializer.deserialize(value);
        }
        catch (ClassCastException e) {
            String msg = this.baseDeserializeExceptionMessage(element, value) + "\nThe type of the object to be deserialized does not match the type the deserializer expects.";
            throw new ConfigurationException(msg, e);
        }
        catch (RuntimeException e) {
            String msg = this.baseDeserializeExceptionMessage(element, value);
            throw new ConfigurationException(msg, e);
        }
        return deserialized;
    }

    protected final Object[] deserializeConfigurationElements(Map<?, ?> serializedConfiguration) {
        List<E> elements = this.elements();
        Object[] result = new Object[elements.size()];
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            ConfigurationElement element = (ConfigurationElement)elements.get(i);
            String formattedName = this.formatter.format(element.name());
            if (!serializedConfiguration.containsKey(formattedName)) {
                Object defaultValue = this.getDefaultValueOf(element);
                result[i] = this.applyPostProcessorForElement(element, defaultValue);
                continue;
            }
            Object serializedValue = serializedConfiguration.get(formattedName);
            result[i] = serializedValue == null && this.properties.inputNulls() ? null : (serializedValue == null ? this.getDefaultValueOf(element) : this.deserialize(element, serializedValue));
            result[i] = this.applyPostProcessorForElement(element, result[i]);
        }
        return result;
    }

    private Object applyPostProcessorForElement(ConfigurationElement<?> element, Object deserializeValue) {
        Object result = deserializeValue;
        boolean postProcessed = false;
        for (Map.Entry<Predicate<ConfigurationElement<?>>, UnaryOperator<?>> entry : this.properties.getPostProcessorsByCondition().entrySet()) {
            Predicate<ConfigurationElement<?>> condition = entry.getKey();
            if (!condition.test(element)) continue;
            UnaryOperator<?> postProcessor = entry.getValue();
            result = TypeSerializer.tryApplyPostProcessorForElement(element, postProcessor, result);
            postProcessed = true;
        }
        if (result == null && postProcessed) {
            TypeSerializer.requirePostProcessorDoesNotReturnNullForPrimitiveElement(element);
        } else if (result == null) {
            TypeSerializer.requireNonPrimitiveType(element);
        }
        return result;
    }

    private static Object tryApplyPostProcessorForElement(ConfigurationElement<?> element, UnaryOperator<?> postProcessor, Object value) {
        try {
            UnaryOperator<?> pp = postProcessor;
            return pp.apply(value);
        }
        catch (ClassCastException e) {
            String msg = String.format("Deserialization of value '%s' for element '%s' of type '%s' failed.\nThe type of the object to be deserialized does not match the type post-processor '%s' expects.", value, element.element(), element.declaringType(), postProcessor);
            throw new ConfigurationException(msg, e);
        }
    }

    private static void requirePostProcessorDoesNotReturnNullForPrimitiveElement(ConfigurationElement<?> element) {
        if (!element.type().isPrimitive()) {
            return;
        }
        if (element instanceof ConfigurationElements.FieldElement) {
            ConfigurationElements.FieldElement fieldElement = (ConfigurationElements.FieldElement)element;
            Field field = fieldElement.element();
            String msg = String.format("Post-processors must not return null for primitive fields but some post-processor of field '%s' does.", field);
            throw new ConfigurationException(msg);
        }
        throw new ConfigurationException("Unhandled ConfigurationElement: " + element);
    }

    private static void requireNonPrimitiveType(ConfigurationElement<?> element) {
        if (!element.type().isPrimitive()) {
            return;
        }
        if (element instanceof ConfigurationElements.FieldElement) {
            ConfigurationElements.FieldElement fieldElement = (ConfigurationElements.FieldElement)element;
            Field field = fieldElement.element();
            String msg = String.format("Cannot set field '%s' to null value. Primitive types cannot be assigned null.", field);
            throw new ConfigurationException(msg);
        }
        throw new ConfigurationException("Unhandled ConfigurationElement: " + element);
    }

    final UnaryOperator<T> createPostProcessorFromAnnotatedMethod() {
        List list = Arrays.stream(this.type.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(PostProcess.class)).filter(x -> !x.isSynthetic()).filter(x -> !this.isAccessorMethod((Method)x)).collect(Collectors.toList());
        if (list.isEmpty()) {
            return UnaryOperator.identity();
        }
        if (list.size() > 1) {
            String methodNames = list.stream().map(Method::toString).collect(Collectors.joining("\n  "));
            String msg = String.format("Configuration types must not define more than one method for post-processing but type '%s' defines %d:\n  %s", this.type, list.size(), methodNames);
            throw new ConfigurationException(msg);
        }
        Method method2 = (Method)list.get(0);
        int modifiers = method2.getModifiers();
        if (Modifier.isAbstract(modifiers) || Modifier.isStatic(modifiers)) {
            String msg = String.format("Post-processing methods must be neither abstract nor static, but post-processing method '%s' of type '%s' is.", method2, this.type);
            throw new ConfigurationException(msg);
        }
        int parameterCount = method2.getParameterCount();
        if (parameterCount > 0) {
            String msg = String.format("Post-processing methods must not define any parameters but post-processing method '%s' of type '%s' defines %d.", method2, this.type, parameterCount);
            throw new ConfigurationException(msg);
        }
        Class<?> returnType = method2.getReturnType();
        if (returnType != Void.TYPE && returnType != this.type) {
            String msg = String.format("The return type of post-processing methods must either be 'void' or the same type as the configuration type in which the post-processing method is defined. The return type of the post-processing method of type '%s' is neither 'void' nor '%s'.", this.type, this.type.getSimpleName());
            throw new ConfigurationException(msg);
        }
        return object -> {
            if (method2.getReturnType() == Void.TYPE) {
                Reflect.invoke(method2, object, new Object[0]);
                return object;
            }
            Object result = Reflect.invoke(method2, object, new Object[0]);
            return result;
        };
    }

    final boolean isAccessorMethod(Method method) {
        return false;
    }

    protected abstract void requireSerializableElements();

    protected abstract String baseDeserializeExceptionMessage(E var1, Object var2);

    protected abstract List<E> elements();

    protected abstract Object getDefaultValueOf(E var1);

    abstract T newDefaultInstance();
}

