/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.util;

import java.util.HashMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;

public final class RomanNumerals {
    private static final Pattern REGEX = Pattern.compile("[IVXLCDM]+");
    private static final TreeMap<Integer, String> toNumeral = new TreeMap();
    private static final HashMap<String, Integer> fromNumeral = new HashMap();

    @NotNull
    public static String convertTo(int number) {
        Validate.isTrue((number > 0 && number < 4000 ? 1 : 0) != 0, (String)"number has no roman numeral equivalent");
        int l = toNumeral.floorKey(number);
        if (number == l) {
            return toNumeral.get(number);
        }
        return toNumeral.get(l) + RomanNumerals.convertTo(number - l);
    }

    public static int convertFrom(@NotNull String number) {
        Validate.isTrue((boolean)REGEX.matcher(number).matches(), (String)"string not valid roman numeral");
        int result = 0;
        int i = 0;
        while (i < number.length()) {
            char currentChar = number.charAt(i);
            int currentVal = RomanNumerals.valueOf(currentChar);
            if (i + 1 < number.length()) {
                char nextChar = number.charAt(i + 1);
                int nextVal = RomanNumerals.valueOf(nextChar);
                if (currentVal < nextVal) {
                    result += nextVal - currentVal;
                    i += 2;
                    continue;
                }
                result += currentVal;
                ++i;
                continue;
            }
            result += currentVal;
            ++i;
        }
        Validate.isTrue((result > 0 && result < 4000 ? 1 : 0) != 0, (String)"number has no roman numeral equivalent");
        return result;
    }

    private static int valueOf(char character) {
        return fromNumeral.get(String.valueOf(character));
    }

    private static void put(int numeric, String numeral) {
        toNumeral.put(numeric, numeral);
        fromNumeral.put(numeral, numeric);
    }

    @Generated
    private RomanNumerals() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        RomanNumerals.put(1000, "M");
        RomanNumerals.put(900, "CM");
        RomanNumerals.put(500, "D");
        RomanNumerals.put(400, "CD");
        RomanNumerals.put(100, "C");
        RomanNumerals.put(90, "XC");
        RomanNumerals.put(50, "L");
        RomanNumerals.put(40, "XL");
        RomanNumerals.put(10, "X");
        RomanNumerals.put(9, "IX");
        RomanNumerals.put(5, "V");
        RomanNumerals.put(4, "IV");
        RomanNumerals.put(1, "I");
    }
}

