/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.util;

import co.crystaldev.alpinecore.util.MaterialHelper;
import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.base.XBase;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class MappedMaterial {
    private final Set<XMaterial> materials;

    public boolean test(@NotNull XMaterial type) {
        return this.materials.contains(type);
    }

    public boolean test(@NotNull Material type) {
        return this.test(MaterialHelper.getType(type));
    }

    public boolean test(@NotNull Block block) {
        return this.test(MaterialHelper.getType(block));
    }

    public boolean test(@NotNull ItemStack item) {
        return this.test(MaterialHelper.getType(item));
    }

    @NotNull
    public static MappedMaterial of(XMaterial ... materials) {
        return new MappedMaterial((Set<XMaterial>)ImmutableSet.copyOf((Object[])materials));
    }

    @NotNull
    public static MappedMaterial of(@NotNull Collection<XMaterial> materials) {
        return new MappedMaterial((Set<XMaterial>)ImmutableSet.copyOf(materials));
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public MappedMaterial(Set<XMaterial> materials) {
        this.materials = materials;
    }

    @Generated
    public Set<XMaterial> getMaterials() {
        return this.materials;
    }

    @Generated
    public String toString() {
        return "MappedMaterial(materials=" + this.getMaterials() + ")";
    }

    public static final class Builder {
        private final Set<XMaterial> materials = new HashSet<XMaterial>();

        @NotNull
        public Builder add(@NotNull MappedMaterial material) {
            this.materials.addAll(material.materials);
            return this;
        }

        @NotNull
        public Builder add(@NotNull Collection<?> materials) {
            for (Object material : materials) {
                if (material instanceof XMaterial) {
                    this.materials.add((XMaterial)material);
                    continue;
                }
                if (!(material instanceof Material)) continue;
                this.materials.add(XMaterial.matchXMaterial((Material)material));
            }
            return this;
        }

        @NotNull
        public Builder add(Object ... materials) {
            for (Object material : materials) {
                if (material instanceof XMaterial) {
                    this.materials.add((XMaterial)material);
                    continue;
                }
                if (!(material instanceof Material)) continue;
                this.materials.add(XMaterial.matchXMaterial((Material)material));
            }
            return this;
        }

        @NotNull
        public Builder add(@NotNull XMaterial material) {
            this.materials.add(material);
            return this;
        }

        @NotNull
        public Builder add(@NotNull Material material) {
            this.materials.add(XMaterial.matchXMaterial(material));
            return this;
        }

        @NotNull
        public Builder add(@NotNull Function<Stream<XMaterial>, Stream<XMaterial>> streamFunction) {
            streamFunction.apply(Stream.of(XMaterial.VALUES).filter(XBase::isSupported)).forEach(this::add);
            return this;
        }

        @NotNull
        public MappedMaterial build() {
            return new MappedMaterial((Set<XMaterial>)ImmutableSet.copyOf(this.materials));
        }

        @Generated
        private Builder() {
        }
    }
}

