/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.util;

import co.crystaldev.alpinecore.util.ReflectionHelper;
import java.lang.reflect.Method;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;

public final class InventoryHelper {
    private static final Method BUKKIT_CREATE_CHEST_INVENTORY = ReflectionHelper.findMethod(Bukkit.class, "createInventory", InventoryHolder.class, Integer.class, Component.class);
    private static final Method BUKKIT_CREATE_VARYING_INVENTORY = ReflectionHelper.findMethod(Bukkit.class, "createInventory", InventoryHolder.class, InventoryType.class, Component.class);

    @NotNull
    public static Inventory createInventory(@NotNull InventoryHolder holder, int slots, @NotNull Component title) {
        if (BUKKIT_CREATE_CHEST_INVENTORY != null) {
            return ReflectionHelper.invokeMethod(Inventory.class, BUKKIT_CREATE_CHEST_INVENTORY, (Object)holder, slots, title);
        }
        return Bukkit.createInventory((InventoryHolder)holder, (int)slots, (String)LegacyComponentSerializer.legacySection().serialize(title));
    }

    @NotNull
    public static Inventory createInventory(@NotNull InventoryHolder holder, @NotNull InventoryType type, @NotNull Component title) {
        if (BUKKIT_CREATE_VARYING_INVENTORY != null) {
            return ReflectionHelper.invokeMethod(Inventory.class, BUKKIT_CREATE_VARYING_INVENTORY, (Object)holder, type, title);
        }
        return Bukkit.createInventory((InventoryHolder)holder, (InventoryType)type, (String)LegacyComponentSerializer.legacySection().serialize(title));
    }
}

