/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.util;

import lombok.Generated;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class ExpUtils {
    public static int getExp(@NotNull Player player) {
        return ExpUtils.getExpFromLevel(player.getLevel()) + Math.round((float)ExpUtils.getExpToNext(player.getLevel()) * player.getExp());
    }

    public static int getExpFromLevel(int level) {
        if (level > 30) {
            return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
        }
        if (level > 15) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return level * level + 6 * level;
    }

    public static double getLevelFromExp(long exp) {
        int level = ExpUtils.getIntLevelFromExp(exp);
        float remainder = (float)exp - (float)ExpUtils.getExpFromLevel(level);
        float progress = remainder / (float)ExpUtils.getExpToNext(level);
        return (double)level + (double)progress;
    }

    public static int getIntLevelFromExp(long exp) {
        if (exp > 1395L) {
            return (int)((Math.sqrt((double)(72L * exp) - 54215.0) + 325.0) / 18.0);
        }
        if (exp > 315L) {
            return (int)(Math.sqrt((double)(40L * exp) - 7839.0) / 10.0 + 8.1);
        }
        if (exp > 0L) {
            return (int)(Math.sqrt((double)exp + 9.0) - 3.0);
        }
        return 0;
    }

    private static int getExpToNext(int level) {
        if (level >= 30) {
            return level * 9 - 158;
        }
        if (level >= 15) {
            return level * 5 - 38;
        }
        return level * 2 + 7;
    }

    public static void changeExp(@NotNull Player player, int exp) {
        if ((exp += ExpUtils.getExp(player)) < 0) {
            exp = 0;
        }
        double levelAndExp = ExpUtils.getLevelFromExp(exp);
        int level = (int)levelAndExp;
        player.setLevel(level);
        player.setExp((float)(levelAndExp - (double)level));
    }

    @Generated
    private ExpUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

