/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class CollectionUtils {
    @SafeVarargs
    @Contract(value="null -> fail")
    @NotNull
    public static <T> List<T> list(T ... items) {
        ArrayList list = new ArrayList(items.length);
        Collections.addAll(list, items);
        return list;
    }

    @SafeVarargs
    @Contract(value="null -> fail")
    @NotNull
    public static <T> LinkedList<T> linkedList(T ... items) {
        LinkedList list = new LinkedList();
        Collections.addAll(list, items);
        return list;
    }

    @SafeVarargs
    @Contract(value="null -> fail")
    @NotNull
    public static <T> Set<T> set(T ... items) {
        HashSet set = new HashSet(items.length);
        Collections.addAll(set, items);
        return set;
    }

    @SafeVarargs
    @Contract(value="null -> fail")
    @NotNull
    public static <T> LinkedHashSet<T> linkedSet(T ... items) {
        LinkedHashSet set = new LinkedHashSet(items.length);
        Collections.addAll(set, items);
        return set;
    }

    @NotNull
    public static <K, V> Map<K, V> map(@NotNull K firstKey, @NotNull V firstValue, Object ... items) {
        int initialCapacity = items.length / 2 + 1;
        HashMap<Object, Object> map = new HashMap<Object, Object>(initialCapacity);
        map.put(firstKey, firstValue);
        if (items.length > 1 || items.length % 2 != 0) {
            for (int i = 0; i < items.length / 2 * 2; i += 2) {
                Object key = items[i];
                Object value = items[i + 1];
                map.put(key, value);
            }
        }
        return map;
    }

    @NotNull
    public static <T> Map<T, T> mapFromArray(T ... items) {
        HashMap<T, T> map = new HashMap<T, T>(items.length / 2);
        for (int i = 0; i < items.length; i += 2) {
            map.put(items[i], items[i + 1]);
        }
        return map;
    }

    @NotNull
    public static <K, V> LinkedHashMap<K, V> linkedMap(@NotNull K firstKey, @NotNull V firstValue, Object ... items) {
        int initialCapacity = items.length / 2 + 1;
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(initialCapacity);
        map.put(firstKey, firstValue);
        if (items.length > 1 || items.length % 2 != 0) {
            for (int i = 0; i < items.length / 2 * 2; i += 2) {
                Object key = items[i];
                Object value = items[i + 1];
                map.put(key, value);
            }
        }
        return map;
    }

    @NotNull
    public static <T> LinkedHashMap<T, T> linkedMapFromArray(T ... items) {
        LinkedHashMap<T, T> map = new LinkedHashMap<T, T>(items.length / 2);
        for (int i = 0; i < items.length; i += 2) {
            map.put(items[i], items[i + 1]);
        }
        return map;
    }

    @Generated
    private CollectionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

