/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.libs.org.apache.commons.dbcp2.managed;

import co.crystaldev.alpinecore.libs.javax.transaction.SystemException;
import co.crystaldev.alpinecore.libs.javax.transaction.Transaction;
import co.crystaldev.alpinecore.libs.javax.transaction.TransactionManager;
import co.crystaldev.alpinecore.libs.javax.transaction.TransactionSynchronizationRegistry;
import co.crystaldev.alpinecore.libs.javax.transaction.xa.XAResource;
import co.crystaldev.alpinecore.libs.org.apache.commons.dbcp2.DelegatingConnection;
import co.crystaldev.alpinecore.libs.org.apache.commons.dbcp2.managed.TransactionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;

public class TransactionRegistry {
    private final TransactionManager transactionManager;
    private final Map<Transaction, TransactionContext> caches = new WeakHashMap<Transaction, TransactionContext>();
    private final Map<Connection, XAResource> xaResources = new WeakHashMap<Connection, XAResource>();
    private final TransactionSynchronizationRegistry transactionSynchronizationRegistry;

    public TransactionRegistry(TransactionManager transactionManager) {
        this(transactionManager, null);
    }

    public TransactionRegistry(TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        this.transactionManager = transactionManager;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionContext getActiveTransactionContext() throws SQLException {
        Transaction transaction = null;
        try {
            transaction = this.transactionManager.getTransaction();
            if (transaction == null) {
                return null;
            }
        }
        catch (SystemException e) {
            throw new SQLException("Unable to determine current transaction ", e);
        }
        TransactionRegistry transactionRegistry = this;
        synchronized (transactionRegistry) {
            return this.caches.computeIfAbsent(transaction, k -> new TransactionContext(this, (Transaction)k, this.transactionSynchronizationRegistry));
        }
    }

    private Connection getConnectionKey(Connection connection) {
        Connection result = connection instanceof DelegatingConnection ? ((DelegatingConnection)connection).getInnermostDelegateInternal() : connection;
        return result;
    }

    public synchronized XAResource getXAResource(Connection connection) throws SQLException {
        Objects.requireNonNull(connection, "connection");
        Connection key = this.getConnectionKey(connection);
        XAResource xaResource = this.xaResources.get(key);
        if (xaResource == null) {
            throw new SQLException("Connection does not have a registered XAResource " + connection);
        }
        return xaResource;
    }

    public synchronized void registerConnection(Connection connection, XAResource xaResource) {
        Objects.requireNonNull(connection, "connection");
        Objects.requireNonNull(xaResource, "xaResource");
        this.xaResources.put(connection, xaResource);
    }

    public synchronized void unregisterConnection(Connection connection) {
        this.xaResources.remove(this.getConnectionKey(connection));
    }
}

