/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.libs.localelib;

import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;

public class SystemResourcesUtil {
    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static Iterator<String> findResourcesBySearch(ClassLoader loader, String baseFolder, String searchCriteria) throws IOException {
        Pattern pattern = Pattern.compile(searchCriteria);
        Enumeration<URL> urls = loader.getResources(baseFolder);
        ArrayList<String> matchingResources = new ArrayList<String>();
        while (urls.hasMoreElements()) {
            String jarPath;
            URL url = urls.nextElement();
            String protocol = url.getProtocol();
            if (!protocol.equals("jar") || (jarPath = SystemResourcesUtil.getJarPath(url)) == null) continue;
            JarFile jarFile = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            Throwable throwable = null;
            try {
                matchingResources.addAll(SystemResourcesUtil.getMatchingResourcesFromJar(jarFile, pattern, baseFolder));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (jarFile == null) continue;
                if (throwable != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                jarFile.close();
            }
        }
        if (matchingResources.isEmpty()) {
            Bukkit.getLogger().warning("[LocaleLib] " + baseFolder + " could not be found!");
        }
        return matchingResources.iterator();
    }

    private static String getJarPath(URL jarUrl) {
        String path = jarUrl.getPath();
        int separatorIndex = path.indexOf(33);
        if (separatorIndex != -1) {
            return path.substring("file:".length(), separatorIndex);
        }
        return null;
    }

    private static List<String> getMatchingResourcesFromJar(JarFile jarFile, Pattern pattern, String baseFolder) {
        ArrayList<String> matchingResources = new ArrayList<String>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String remainingPath;
            Matcher matcher;
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.startsWith(baseFolder) || !(matcher = pattern.matcher(remainingPath = entryName.substring(baseFolder.length()))).find()) continue;
            matchingResources.add(entryName);
        }
        return matchingResources;
    }
}

