/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.libs.localelib;

import co.crystaldev.alpinecore.libs.localelib.LocaleKeys;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.data.Ageable;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.Potion;

public class LocaleManager {
    private static final Pattern rgbPattern = Pattern.compile("\u00a7x(\u00a7[0-9a-fA-F]){6}");
    private static Class<?> craftMagicNumbers = null;
    private static Class<?> itemClazz = null;
    private static boolean oldVersion = false;
    private static boolean hasBasePotionData = false;
    private static boolean hasRepackagedNms = false;
    private static boolean isPost1dot18 = false;
    private final Map<String, String> oldBlocks = LocaleKeys.getBlockKeys();
    private final Map<String, String> oldItems = LocaleKeys.getItemKeys();
    private final Map<String, String> oldPotions1dot8 = LocaleKeys.getPotionKeys1dot8();
    private final Map<String, String> oldPotions = LocaleKeys.getPotionKeys();
    private final Map<String, String> oldLingeringPotions = LocaleKeys.getLingeringPotionKeys();
    private final Map<String, String> oldSplashPotions = LocaleKeys.getSplashPotionKeys();
    private final Map<String, String> oldEntities = LocaleKeys.getEntityKeys();
    private Map<String, String> englishTranslations;

    public LocaleManager() {
        oldVersion = this.isBelow113();
        if (Material.getMaterial((String)"LINGERING_POTION") != null) {
            hasBasePotionData = true;
        }
        if (Material.getMaterial((String)"AMETHYST_CLUSTER") != null) {
            hasRepackagedNms = true;
        }
        if (Material.getMaterial((String)"MUSIC_DISC_OTHERSIDE") != null) {
            isPost1dot18 = true;
        }
        String packageName = Bukkit.getServer().getClass().getPackage().getName();
        try {
            if (packageName.equals("org.bukkit.craftbukkit")) {
                craftMagicNumbers = Class.forName("org.bukkit.craftbukkit.util.CraftMagicNumbers");
                itemClazz = Class.forName("net.minecraft.world.item.Item");
            } else {
                String version = packageName.split("\\.")[3];
                craftMagicNumbers = Class.forName("org.bukkit.craftbukkit.{v}.util.CraftMagicNumbers".replace("{v}", version));
                itemClazz = hasRepackagedNms ? Class.forName("net.minecraft.world.item.Item") : Class.forName("net.minecraft.server.{v}.Item".replace("{v}", version));
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        try {
            this.englishTranslations = LocaleKeys.loadTranslations();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean sendMessage(Player player, String message, ItemStack itemStack) {
        if (player == null || itemStack == null) {
            return false;
        }
        if (!hasBasePotionData && itemStack.getType().equals((Object)Material.POTION)) {
            Potion potion = Potion.fromItemStack((ItemStack)itemStack);
            String msg = message;
            if (potion.isSplash()) {
                msg = message.replace("<item>", "<prefix> <item>").replace("<prefix>", this.translate(message, "potion.prefix.grenade", "<prefix>"));
            }
            String potionName = "item.potion.name";
            if (potion.getType().getEffectType() != null) {
                potionName = this.oldPotions1dot8.get(potion.getType().getEffectType().getName());
            }
            msg = msg.replace("<item>", this.translate(message, potionName, "<item>"));
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("tellraw " + this.formatName(player) + " [\"" + msg + "\"]"));
            return true;
        }
        return this.sendMessage(player, message, itemStack.getType(), itemStack.getDurability(), itemStack.getEnchantments(), itemStack.getItemMeta());
    }

    public boolean sendMessage(Player player, String message, Material material, short durability, Map<Enchantment, Integer> enchantments, ItemMeta meta) {
        String matKey;
        if (player == null || material == null) {
            return false;
        }
        try {
            matKey = this.queryMaterial(material, durability, meta);
        }
        catch (Exception ex) {
            Bukkit.getLogger().severe("[LocaleLib] Unable to query Material: " + material.name());
            ex.printStackTrace();
            return false;
        }
        if (meta instanceof EnchantmentStorageMeta) {
            enchantments = ((EnchantmentStorageMeta)meta).getStoredEnchants();
        }
        Collection<String> enchantKeys = this.queryEnchantments(enchantments).values();
        Collection<String> lvlKeys = this.queryLevels(enchantments).values();
        String msg = message.replace("<item>", this.translate(message, matKey, "<item>"));
        for (String ek : enchantKeys) {
            msg = msg.replaceFirst("<enchantment>", this.translate(msg, ek, "<enchantment>"));
        }
        for (String lk : lvlKeys) {
            msg = msg.replaceFirst("<level>", this.translate(msg, lk, "<level>"));
        }
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("tellraw " + this.formatName(player) + " [\"" + msg + "\"]"));
        return true;
    }

    public boolean sendMessage(Player player, String message, Material material, short durability, Map<Enchantment, Integer> enchantments) {
        return this.sendMessage(player, message, material, durability, enchantments, null);
    }

    public boolean sendMessage(Player player, String message, Map<Enchantment, Integer> enchantments) {
        if (player == null || message == null || enchantments == null) {
            return false;
        }
        Collection<String> enchantKeys = this.queryEnchantments(enchantments).values();
        Collection<String> levelKeys = this.queryLevels(enchantments).values();
        String msg = message;
        if (!enchantKeys.isEmpty()) {
            for (String ek : enchantKeys) {
                msg = message.replaceFirst("<enchantment>", this.translate(message, ek, "<enchantment>"));
            }
            for (String lk : levelKeys) {
                msg = message.replaceFirst("<level>", this.translate(message, lk, "<level>"));
            }
        }
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("tellraw " + this.formatName(player) + " [\"" + msg + "\"]"));
        return true;
    }

    public boolean sendMessage(Player player, String message, EntityType type, String extra) {
        if (player == null || message == null || type == null) {
            return false;
        }
        String key = this.queryEntityType(type, extra);
        String msg = message.replace("<mob>", this.translate(message, key, "<mob>"));
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("tellraw " + this.formatName(player) + " [\"" + msg + "\"]"));
        return true;
    }

    public String queryEntity(Entity entity) throws IllegalArgumentException {
        Rabbit rabbit;
        if (entity == null) {
            throw new IllegalArgumentException("[LocaleLib] Entity cannot be null");
        }
        String extra = null;
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            extra = villager.getProfession().name();
        } else if (entity instanceof Ocelot) {
            Ocelot ocelot = (Ocelot)entity;
            extra = ocelot.getCatType().name();
        } else if (entity instanceof Rabbit && (rabbit = (Rabbit)entity).getRabbitType().equals((Object)Rabbit.Type.THE_KILLER_BUNNY)) {
            extra = rabbit.getRabbitType().name();
        }
        if (!oldVersion && entity instanceof TropicalFish) {
            TropicalFish tropicalFish = (TropicalFish)entity;
            extra = tropicalFish.getPattern().name();
        }
        return this.queryEntityType(entity.getType(), extra);
    }

    public String queryEntityType(EntityType entityType, String extra) throws IllegalArgumentException {
        if (entityType == null) {
            throw new IllegalArgumentException("[LocaleLib] EntityType cannot be null");
        }
        String key = "";
        if (oldVersion) {
            key = entityType.name().equals("VILLAGER") && extra != null && Villager.Profession.valueOf((String)extra) != null ? this.oldEntities.get(entityType.name() + "." + Villager.Profession.valueOf((String)extra).name()) : (entityType.name().equals("OCELOT") && extra != null && Ocelot.Type.valueOf((String)extra) != null ? this.oldEntities.get(entityType.name() + "." + Ocelot.Type.valueOf((String)extra).name()) : (entityType.name().equals("RABBIT") && extra != null && Rabbit.Type.valueOf((String)extra) != null && Rabbit.Type.valueOf((String)extra).equals((Object)Rabbit.Type.THE_KILLER_BUNNY) ? this.oldEntities.get(entityType.name() + "." + Rabbit.Type.valueOf((String)extra).name()) : this.oldEntities.get(entityType.name())));
        } else if (entityType.name().equals("MUSHROOM_COW")) {
            key = "entity.minecraft.mooshroom";
        } else if (entityType.name().equals("SNOWMAN")) {
            key = "entity.minecraft.snow_golem";
        } else if (entityType.name().equals("PIG_ZOMBIE")) {
            key = "entity.minecraft.zombie_pigman";
        } else if (entityType.name().equals("VILLAGER") && extra != null && Villager.Profession.valueOf((String)extra) != null) {
            key = "entity.minecraft.villager." + Villager.Profession.valueOf((String)extra).name();
        } else if (entityType.name().equals("RABBIT") && extra != null && Rabbit.Type.valueOf((String)extra) != null && Rabbit.Type.valueOf((String)extra).equals((Object)Rabbit.Type.THE_KILLER_BUNNY)) {
            key = "entity.minecraft.killer_bunny";
        } else if (entityType.name().equals("TROPICAL_FISH") && extra != null) {
            if (TropicalFish.Pattern.valueOf((String)extra) != null) {
                key = "entity.minecraft.tropical_fish.type." + TropicalFish.Pattern.valueOf((String)extra);
            } else {
                try {
                    int value = Integer.parseInt(extra);
                    if (value >= 0 && value < 22) {
                        key = "entity.minecraft.tropical_fish.predefined." + extra;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            key = "entity.minecraft." + entityType.toString().toLowerCase();
        }
        return key;
    }

    public String queryItemStack(ItemStack itemStack) throws IllegalArgumentException {
        if (itemStack == null) {
            throw new IllegalArgumentException("[LocaleLib] ItemStack cannot be null");
        }
        return this.queryMaterial(itemStack.getType(), itemStack.getDurability(), itemStack.getItemMeta());
    }

    public String queryMaterial(Material material) throws IllegalArgumentException {
        return this.queryMaterial(material, (short)0, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String queryMaterial(Material material, short durability, ItemMeta meta) throws IllegalArgumentException {
        if (material == null) {
            throw new IllegalArgumentException("[LocaleLib] Material cannot be null");
        }
        String matKey = "";
        if (oldVersion) {
            if (material.isBlock()) {
                if (durability >= 0 && this.oldBlocks.containsKey(material.name() + "." + durability)) {
                    return this.oldBlocks.get(material.name() + "." + durability);
                }
                if (!this.oldBlocks.containsKey(material.name())) throw new IllegalArgumentException("[LocaleLib] Block not found: " + material.name() + "." + durability);
                return this.oldBlocks.get(material.name());
            }
            ItemStack i = new ItemStack(material, 1, durability);
            i.setItemMeta(meta);
            if (durability >= 0 && i.getItemMeta() instanceof PotionMeta) {
                if (!hasBasePotionData) return matKey;
                if (material.equals((Object)Material.POTION)) {
                    return this.oldPotions.get(((PotionMeta)i.getItemMeta()).getBasePotionData().getType().name());
                }
                if (material.equals((Object)Material.LINGERING_POTION)) {
                    return this.oldLingeringPotions.get(((PotionMeta)i.getItemMeta()).getBasePotionData().getType().name());
                }
                if (!material.equals((Object)Material.SPLASH_POTION)) return matKey;
                return this.oldSplashPotions.get(((PotionMeta)i.getItemMeta()).getBasePotionData().getType().name());
            }
            if (durability >= 0 && this.oldItems.containsKey(material.name() + "." + durability)) {
                return this.oldItems.get(material.name() + "." + durability);
            }
            if (!this.oldItems.containsKey(material.name())) throw new IllegalArgumentException("[LocaleLib] Item not found: " + material.name() + "." + durability);
            return this.oldItems.get(material.name());
        }
        if (material.isBlock() && material.createBlockData() instanceof Ageable) {
            return "block.minecraft." + material.name().toLowerCase();
        }
        try {
            Method itemMethod = craftMagicNumbers.getDeclaredMethod("getItem", material.getClass());
            itemMethod.setAccessible(true);
            Object item = itemMethod.invoke(craftMagicNumbers, material);
            if (item == null) {
                throw new IllegalArgumentException(material.name() + " material could not be queried!");
            }
            Method keyMethod = LocaleManager.resolveMethod(itemClazz, "getDescriptionId", "a", "getName", "j", "l");
            if (keyMethod == null) {
                throw new IllegalArgumentException("Could not get description ID for " + itemClazz.getName());
            }
            matKey = (String)keyMethod.invoke(item, new Object[0]);
            if (!(meta instanceof PotionMeta)) return matKey;
            if ((matKey = matKey + ".effect." + ((PotionMeta)meta).getBasePotionData().getType().name().toLowerCase().replace("speed", "swiftness").replace("jump", "leaping").replace("instant_heal", "healing").replace("instant_damage", "harming")).contains("regeneration")) return matKey;
            return matKey.replace("regen", "regeneration");
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("[LocaleLib] Unable to query Material: " + material.name(), ex);
        }
    }

    private static Method resolveMethod(Class<?> clazz, String ... mappings) {
        for (String mapping : mappings) {
            try {
                Method declaredMethod = clazz.getDeclaredMethod(mapping, new Class[0]);
                declaredMethod.setAccessible(true);
                return declaredMethod;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return null;
    }

    public Map<Enchantment, String> queryEnchantments(Map<Enchantment, Integer> enchantments) {
        HashMap<Enchantment, String> enchantKeys = new HashMap<Enchantment, String>();
        if (enchantments == null || enchantments.isEmpty()) {
            return enchantKeys;
        }
        if (oldVersion) {
            for (Enchantment e : enchantments.keySet()) {
                enchantKeys.put(e, "enchantment." + e.getName().toLowerCase().replace("_", ".").replace("environmental", "all").replace("protection", "protect"));
            }
        } else {
            for (Enchantment e : enchantments.keySet()) {
                String str = e.toString();
                enchantKeys.put(e, "enchantment.minecraft." + str.substring(str.indexOf(":") + 1, str.indexOf("]")).split(", ")[0]);
            }
        }
        return enchantKeys;
    }

    public Map<Integer, String> queryLevels(Map<Enchantment, Integer> enchantments) {
        HashMap<Integer, String> lvlKeys = new HashMap<Integer, String>();
        if (enchantments == null || enchantments.isEmpty()) {
            return lvlKeys;
        }
        for (Integer i : enchantments.values()) {
            lvlKeys.put(i, "enchantment.level." + i);
        }
        return lvlKeys;
    }

    public String toServerLocale(String key) {
        return this.englishTranslations.getOrDefault(key, "<none>");
    }

    private String translate(String message, String key, String placeholder) {
        String replacement = "\",{\"translate\":\"" + key + "\"";
        String text = message.split(placeholder)[0];
        if (text.contains("\u00a7")) {
            Matcher matcher = rgbPattern.matcher(text);
            if (matcher.find()) {
                replacement = replacement + ", \"color\":\"#" + matcher.group().replace("\u00a7", "").substring(1) + "\"";
            } else {
                ChatColor color = ChatColor.getByChar((String)ChatColor.getLastColors((String)text).replace("\u00a7", ""));
                if (color != null) {
                    String colorName = color.name();
                    replacement = replacement + ", \"color\":\"" + colorName.toLowerCase() + "\"";
                }
            }
        }
        replacement = replacement + "},\"";
        return replacement;
    }

    private String formatName(Player player) {
        if (!this.isBelow113()) {
            return "\"" + player.getName() + "\"";
        }
        return player.getName();
    }

    public boolean hasBasePotionData() {
        return hasBasePotionData;
    }

    public boolean hasRepackagedNms() {
        return hasRepackagedNms;
    }

    public boolean isBelow113() {
        return this._isBelow113(Bukkit.getServer().getBukkitVersion().split("-")[0]);
    }

    private boolean _isBelow113(String bukkitVersion) {
        if (bukkitVersion.matches("^[0-9.]+$")) {
            switch (bukkitVersion) {
                case "1.12.2": 
                case "1.12.1": 
                case "1.12": 
                case "1.11.2": 
                case "1.11.1": 
                case "1.11": 
                case "1.10.2": 
                case "1.10.1": 
                case "1.10": 
                case "1.9.4": 
                case "1.9.3": 
                case "1.9.2": 
                case "1.9.1": 
                case "1.9": 
                case "1.8.9": 
                case "1.8.8": 
                case "1.8.7": 
                case "1.8.6": 
                case "1.8.5": 
                case "1.8.4": 
                case "1.8.3": 
                case "1.8.2": 
                case "1.8.1": 
                case "1.8": 
                case "1.7.10": 
                case "1.7.9": 
                case "1.7.2": {
                    return true;
                }
            }
            return false;
        }
        Bukkit.getLogger().severe("[LocaleLib] Received invalid Bukkit version " + bukkitVersion);
        return false;
    }
}

