/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.integration;

import co.crystaldev.alpinecore.AlpinePlugin;
import co.crystaldev.alpinecore.framework.integration.AlpineIntegration;
import co.crystaldev.alpinecore.framework.integration.AlpineIntegrationEngine;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlaceholderIntegration
extends AlpineIntegration {
    private PlaceholderIntegration(@NotNull AlpinePlugin plugin) {
        super(plugin);
    }

    @Override
    protected boolean shouldActivate() {
        return this.plugin.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI");
    }

    @Override
    @NotNull
    protected Class<? extends AlpineIntegrationEngine> getEngineClass() {
        return PlaceholderEngine.class;
    }

    @Override
    @NotNull
    public PlaceholderEngine getEngine() {
        PlaceholderEngine engine = (PlaceholderEngine)super.getEngine();
        if (engine == null) {
            throw new IllegalStateException("PlaceholderAPI not installed");
        }
        return engine;
    }

    @NotNull
    public String replace(@Nullable OfflinePlayer target, boolean miniMessage, @NotNull String text) {
        if (this.isActive()) {
            return this.getEngine().replace(target, text, miniMessage);
        }
        return text;
    }

    @NotNull
    public String replace(@Nullable OfflinePlayer target, @Nullable OfflinePlayer other, boolean miniMessage, @NotNull String text) {
        if (this.isActive()) {
            return this.getEngine().replace(target, other, text, miniMessage);
        }
        return text;
    }

    @NotNull
    public String replace(@Nullable CommandSender target, boolean miniMessage, @NotNull String text) {
        if (this.isActive()) {
            return this.getEngine().replace(target, text, miniMessage);
        }
        return text;
    }

    @NotNull
    public String replace(@Nullable CommandSender target, @Nullable CommandSender other, boolean miniMessage, @NotNull String text) {
        if (this.isActive()) {
            return this.getEngine().replace(target, other, text, miniMessage);
        }
        return text;
    }

    public static final class PlaceholderEngine
    extends AlpineIntegrationEngine {
        private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("%([^%]+)%");

        PlaceholderEngine(@NotNull AlpinePlugin plugin) {
            super(plugin);
        }

        @NotNull
        public String replace(@Nullable OfflinePlayer sender, @NotNull String text, boolean miniMessage) {
            if (sender == null) {
                return text;
            }
            if (sender instanceof Player) {
                return PlaceholderEngine.sanitize(this.plugin, miniMessage, text, v -> PlaceholderAPI.setPlaceholders((Player)((Player)sender), (String)v));
            }
            return PlaceholderEngine.sanitize(this.plugin, miniMessage, text, v -> PlaceholderAPI.setPlaceholders((OfflinePlayer)sender, (String)v));
        }

        @NotNull
        public String replace(@Nullable OfflinePlayer sender, @Nullable OfflinePlayer target, @NotNull String text, boolean miniMessage) {
            if (!(target instanceof Player)) {
                return this.replace(sender, text, miniMessage);
            }
            text = this.replace(sender, text, miniMessage);
            if (sender instanceof Player) {
                return PlaceholderEngine.sanitize(this.plugin, miniMessage, text, v -> PlaceholderAPI.setRelationalPlaceholders((Player)((Player)sender), (Player)((Player)target), (String)v));
            }
            return PlaceholderEngine.sanitize(this.plugin, miniMessage, text, v -> PlaceholderAPI.setPlaceholders((OfflinePlayer)sender, (String)v));
        }

        @NotNull
        public String replace(@Nullable CommandSender sender, @NotNull String text, boolean miniMessage) {
            if (!(sender instanceof OfflinePlayer)) {
                return text;
            }
            return this.replace((OfflinePlayer)sender, text, miniMessage);
        }

        @NotNull
        public String replace(@Nullable CommandSender sender, @Nullable CommandSender target, @NotNull String text, boolean miniMessage) {
            if (!(sender instanceof Player)) {
                return text;
            }
            if (!(target instanceof Player)) {
                return this.replace(sender, text, miniMessage);
            }
            return this.replace((OfflinePlayer)sender, (OfflinePlayer)((Player)target), text, miniMessage);
        }

        @NotNull
        private static String sanitize(@NotNull AlpinePlugin plugin, boolean serialize, @NotNull String text, @NotNull Function<String, String> transformer) {
            Matcher matcher = PLACEHOLDER_PATTERN.matcher(text);
            while (matcher.find()) {
                String placeholder = matcher.group();
                String replaced = transformer.apply(placeholder);
                if (replaced.trim().isEmpty()) {
                    text = text.replace(placeholder, "");
                    continue;
                }
                replaced = ChatColor.translateAlternateColorCodes((char)'&', (String)replaced);
                if (serialize && replaced.contains("\u00a7")) {
                    MiniMessage miniMessage = plugin.getStrictMiniMessage();
                    LegacyComponentSerializer serializer = LegacyComponentSerializer.legacySection();
                    replaced = (String)miniMessage.serialize(serializer.deserialize(replaced));
                }
                text = text.replace(placeholder, replaced);
            }
            return text;
        }
    }
}

