/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.teleport;

import co.crystaldev.alpinecore.AlpineCore;
import co.crystaldev.alpinecore.AlpinePlugin;
import co.crystaldev.alpinecore.framework.teleport.TeleportContext;
import co.crystaldev.alpinecore.framework.teleport.TeleportHandler;
import co.crystaldev.alpinecore.framework.teleport.TeleportListener;
import co.crystaldev.alpinecore.framework.teleport.TeleportTask;
import co.crystaldev.alpinecore.util.Messaging;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.ServicesManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class TeleportManager {
    @NotNull
    private final AlpinePlugin plugin;
    private final Map<Player, TeleportTask> tasks = new ConcurrentHashMap<Player, TeleportTask>();

    @ApiStatus.Internal
    public TeleportManager(@NotNull AlpinePlugin plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)new TeleportListener(this, this.tasks), (Plugin)this.plugin);
    }

    @NotNull
    public TeleportHandler getTeleportHandler() {
        ServicesManager servicesManager = this.plugin.getServer().getServicesManager();
        RegisteredServiceProvider registration = servicesManager.getRegistration(TeleportHandler.class);
        return (TeleportHandler)registration.getProvider();
    }

    public void registerHandler(@NotNull TeleportHandler handler) {
        Validate.notNull((Object)handler, (String)"handler cannot be null");
        ServicesManager servicesManager = this.plugin.getServer().getServicesManager();
        RegisteredServiceProvider registration = servicesManager.getRegistration(TeleportHandler.class);
        if (registration != null && !(registration.getPlugin() instanceof AlpineCore)) {
            this.plugin.log(Level.WARNING, String.format("Replacing teleport handler \"%s\" with %s", registration.getPlugin().getName(), this.plugin.getName()));
        }
        servicesManager.register(TeleportHandler.class, (Object)handler, (Plugin)this.plugin, ServicePriority.Highest);
    }

    public void initiateTeleport(@NotNull TeleportTask task) {
        TeleportHandler handler = this.getTeleportHandler();
        TeleportContext context = task.createContext(false);
        task.getCallbacks().getOnInit().accept(context);
        handler.onInit(context);
        task.getCallbacks().getOnApply().accept(context);
        handler.onApply(context);
        task.apply(context);
        if (!context.isCancelled()) {
            Messaging.send((CommandSender)context.player(), context.messageType(), context.message());
            TeleportTask oldTask = this.tasks.put(task.getPlayer(), task);
            if (oldTask != null) {
                TeleportManager.cancelTask(oldTask, handler);
            }
        } else {
            TeleportManager.cancelTask(task, handler);
        }
    }

    public void cancel(@NotNull Player player) {
        TeleportTask task = this.tasks.remove(player);
        if (task != null) {
            TeleportManager.cancelTask(task, this.getTeleportHandler());
        }
    }

    private static void cancelTask(@NotNull TeleportTask task, @NotNull TeleportHandler handler) {
        TeleportContext context = task.createContext(true);
        handler.onCancel(context);
        task.getCallbacks().getOnCancel().accept(context);
        Messaging.send((CommandSender)context.player(), context.messageType(), context.message());
    }
}

