/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.storage.driver;

import co.crystaldev.alpinecore.AlpineCore;
import co.crystaldev.alpinecore.AlpinePlugin;
import co.crystaldev.alpinecore.Reference;
import co.crystaldev.alpinecore.framework.storage.KeySerializer;
import co.crystaldev.alpinecore.framework.storage.SerializerRegistry;
import co.crystaldev.alpinecore.framework.storage.driver.AlpineDriver;
import co.crystaldev.alpinecore.util.DatabaseConnection;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class MySqlDriver<K, D>
extends AlpineDriver<K, D> {
    private final Class<D> dataType;
    private final Gson gson;
    private final DatabaseConnection connection;
    private final String table;

    private MySqlDriver(@NotNull AlpinePlugin plugin, @NotNull String url, @NotNull String table, @NotNull String username, @NotNull String password, @NotNull Class<D> dataType, @NotNull Gson gson) {
        super(plugin);
        this.table = table;
        this.dataType = dataType;
        this.gson = gson;
        this.connection = new DatabaseConnection(null, url, username, password);
        if (this.getConnection() == null) {
            throw new IllegalStateException("Unable to establish connection to the database");
        }
        try {
            if (!this.doesTableExist()) {
                this.createTable();
            }
        }
        catch (SQLException ex) {
            throw new IllegalStateException(String.format("Unable to create table \"%s\"", this.table), ex);
        }
        try {
            if (!this.validateColumns()) {
                throw new IllegalStateException("Table columns do not match");
            }
        }
        catch (SQLException ex) {
            throw new IllegalStateException(String.format("Unable to validate columns in table \"%s\"", this.table), ex);
        }
    }

    @Override
    public boolean persistEntry(@NotNull K key, @NotNull D data) {
        boolean bl;
        block9: {
            Connection conn = this.getConnection();
            String sql = "INSERT INTO " + this.table + " (data_key, storage) VALUES (?, ?) ON DUPLICATE KEY UPDATE storage = ?";
            if (conn == null) {
                throw new IllegalStateException("Database connection is not active");
            }
            PreparedStatement statement = conn.prepareStatement(sql);
            try {
                statement.setObject(1, this.serializeKey(key));
                statement.setString(2, this.gson.toJson(data));
                int affectedRows = statement.executeUpdate();
                boolean bl2 = bl = affectedRows > 0;
                if (statement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    AlpineCore.getInstance().log("Unable to persist entry", ex);
                    return false;
                }
            }
            statement.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean persistEntries(@NotNull Map<K, D> entries) {
        boolean bl;
        PreparedStatement statement;
        Connection conn;
        block21: {
            conn = this.getConnection();
            String sql = "INSERT INTO " + this.table + " (data_key, storage) VALUES (?, ?) ON DUPLICATE KEY UPDATE storage = VALUES(storage)";
            if (conn == null) {
                throw new IllegalStateException("Database connection is not active");
            }
            statement = conn.prepareStatement(sql);
            conn.setAutoCommit(false);
            for (Map.Entry<K, D> entry : entries.entrySet()) {
                K key = entry.getKey();
                D value = entry.getValue();
                statement.setObject(1, this.serializeKey(key));
                statement.setString(2, this.gson.toJson(value));
                statement.addBatch();
            }
            statement.executeBatch();
            conn.commit();
            bl = true;
            if (statement == null) break block21;
            statement.close();
        }
        try {
            conn.setAutoCommit(true);
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return bl;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException ex) {
                        try {
                            conn.rollback();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        ex.printStackTrace();
                        boolean bl2 = false;
                        return bl2;
                    }
                }
                catch (Throwable throwable3) {
                    throw throwable3;
                }
                finally {
                    try {
                        conn.setAutoCommit(true);
                        conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean deleteEntry(@NotNull K key) {
        boolean bl;
        PreparedStatement statement;
        Connection conn;
        block18: {
            conn = this.getConnection();
            String sql = "DELETE FROM " + this.table + " WHERE data_key = ?";
            if (conn == null) {
                throw new IllegalStateException("Database connection is not active");
            }
            statement = conn.prepareStatement(sql);
            statement.setObject(1, this.serializeKey(key));
            int affectedRows = statement.executeUpdate();
            boolean bl2 = bl = affectedRows > 0;
            if (statement == null) break block18;
            statement.close();
        }
        try {
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return bl;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException ex) {
                        AlpineCore.getInstance().log("Unable to delete entry", ex);
                        boolean bl3 = false;
                        return bl3;
                    }
                }
                catch (Throwable throwable3) {
                    throw throwable3;
                }
                finally {
                    try {
                        conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean hasEntry(@NotNull K key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public D retrieveEntry(@NotNull K key) throws Exception {
        Connection conn = this.getConnection();
        String sql = "SELECT storage FROM " + this.table + " WHERE data_key = ?";
        if (conn == null) {
            throw new IllegalStateException("Database connection is not active");
        }
        try (PreparedStatement statement = conn.prepareStatement(sql);){
            statement.setObject(1, this.serializeKey(key));
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) throw new NoSuchElementException(String.format("No entry found for key \"%s\"", this.serializeKey(key)));
                String data = resultSet.getString("storage");
                Object object = this.gson.fromJson(data, this.dataType);
                return (D)object;
            }
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Collection<D> getAllEntries() throws Exception {
        Connection conn = this.getConnection();
        if (conn == null) {
            throw new IllegalStateException("Database connection is not active");
        }
        String sql = "SELECT storage FROM " + this.table;
        ArrayList<Object> entries = new ArrayList<Object>();
        try (PreparedStatement statement = conn.prepareStatement(sql);){
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String data = resultSet.getString("storage");
                entries.add(this.gson.fromJson(data, this.dataType));
            }
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
        return ImmutableList.copyOf(entries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Collection<D> getAllEntries(@Nullable Consumer<Exception> exceptionConsumer) {
        Connection conn = this.getConnection();
        if (conn == null) {
            throw new IllegalStateException("Database connection is not active");
        }
        String sql = "SELECT storage FROM " + this.table;
        ArrayList<Object> entries = new ArrayList<Object>();
        try (PreparedStatement statement = conn.prepareStatement(sql);){
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                try {
                    String data = resultSet.getString("storage");
                    entries.add(this.gson.fromJson(data, this.dataType));
                }
                catch (Exception ex) {
                    if (exceptionConsumer == null) continue;
                    exceptionConsumer.accept(ex);
                }
            }
        }
        catch (SQLException ex) {
            if (exceptionConsumer != null) {
                exceptionConsumer.accept(ex);
            }
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
        return ImmutableList.copyOf(entries);
    }

    @Override
    public void shutdown() {
        this.connection.shutdown();
    }

    @NotNull
    private Object serializeKey(@NotNull K key) {
        SerializerRegistry registry = this.plugin.getSerializerRegistry();
        KeySerializer<?, ?> serializer = null;
        for (Class<?> clazz : registry.getKeySerializers().keySet()) {
            if (!clazz.isAssignableFrom(key.getClass())) continue;
            serializer = registry.getKeySerializer(clazz);
        }
        if (serializer == null) {
            throw new NullPointerException(String.format("No key serializer registered for type \"%s\"", key.getClass().getName()));
        }
        return serializer.serialize(key);
    }

    @Nullable
    private Connection getConnection() {
        try {
            return this.connection.getConnection();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private boolean doesTableExist() throws SQLException {
        try (Connection conn = this.connection.getConnection();){
            boolean bl;
            block12: {
                DatabaseMetaData meta = conn.getMetaData();
                ResultSet rs = meta.getTables(null, null, this.table, null);
                try {
                    bl = rs.next();
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
    }

    private void createTable() throws SQLException {
        String sql = "CREATE TABLE " + this.table + " (id INT AUTO_INCREMENT PRIMARY KEY, data_key VARCHAR(255) NOT NULL, storage JSON, UNIQUE(data_key))";
        try (Connection conn = this.connection.getConnection();
             Statement statement = conn.createStatement();){
            statement.execute(sql);
        }
    }

    private boolean validateColumns() throws SQLException {
        String[] columns = new String[]{"id", "data_key", "storage"};
        ArrayList<String> existingColumns = new ArrayList<String>();
        try (Connection conn = this.connection.getConnection();){
            DatabaseMetaData meta = conn.getMetaData();
            try (ResultSet rs = meta.getColumns(null, null, this.table, null);){
                while (rs.next()) {
                    existingColumns.add(rs.getString("COLUMN_NAME"));
                }
            }
        }
        for (String column : columns) {
            if (existingColumns.contains(column)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static <K, D> Builder<K, D> builder() {
        return new Builder();
    }

    public static final class Builder<K, D> {
        private String url;
        private String table;
        private String username;
        private String password;
        private Class<D> dataType;
        private Gson gson = Reference.GSON;

        @NotNull
        public Builder<K, D> url(@NotNull String url) {
            this.url = url;
            return this;
        }

        @NotNull
        public Builder<K, D> table(@NotNull String table) {
            this.table = table;
            return this;
        }

        @NotNull
        public Builder<K, D> host(@NotNull String host, int port, @NotNull String database, @NotNull String table) {
            this.table = table;
            if (port < 0) {
                return this.url(String.format("jdbc:mysql://%s/%s", host, database));
            }
            return this.url(String.format("jdbc:mysql://%s:%s/%s", host, port, database));
        }

        @NotNull
        public Builder<K, D> host(@NotNull String host, @NotNull String database, @NotNull String table) {
            return this.host(host, -1, database, table);
        }

        @NotNull
        public Builder<K, D> credentials(@NotNull String username, @NotNull String password) {
            this.username = username;
            this.password = password;
            return this;
        }

        @NotNull
        public Builder<K, D> dataType(@NotNull Class<D> dataType) {
            this.dataType = dataType;
            return this;
        }

        @NotNull
        public Builder<K, D> gson(@NotNull Gson gson) {
            this.gson = gson;
            return this;
        }

        @NotNull
        public MySqlDriver<K, D> build(@NotNull AlpinePlugin plugin) {
            Validate.notNull((Object)this.url, (String)"url must not be null");
            Validate.notNull((Object)this.table, (String)"table must not be null");
            Validate.notNull(this.dataType, (String)"dataType must not be null");
            return new MySqlDriver(plugin, this.url, this.table, this.username, this.password, this.dataType, this.gson);
        }

        @Deprecated
        @NotNull
        public MySqlDriver<K, D> build() {
            return this.build(AlpineCore.getInstance());
        }
    }
}

