/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.storage.driver;

import co.crystaldev.alpinecore.AlpineCore;
import co.crystaldev.alpinecore.AlpinePlugin;
import co.crystaldev.alpinecore.Reference;
import co.crystaldev.alpinecore.framework.storage.KeySerializer;
import co.crystaldev.alpinecore.framework.storage.SerializerRegistry;
import co.crystaldev.alpinecore.framework.storage.driver.AlpineDriver;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FlatfileDriver<K, D>
extends AlpineDriver<K, D> {
    private final File directory;
    private final Gson gson;
    private final Class<D> dataType;

    private FlatfileDriver(@NotNull AlpinePlugin plugin, @NotNull File directory, @NotNull Gson gson, @NotNull Class<D> dataType) {
        super(plugin);
        this.directory = directory;
        this.gson = gson;
        this.dataType = dataType;
    }

    @Override
    public boolean persistEntry(@NotNull K key, @NotNull D data) {
        try {
            File file = this.getFileForKey(key);
            if (!file.exists() && !file.createNewFile()) {
                throw new IOException("Failed to create store file for " + key);
            }
            FileWriter writer = new FileWriter(file);
            this.gson.toJson(data, (Appendable)writer);
            writer.close();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean deleteEntry(@NotNull K key) {
        try {
            File file = this.getFileForKey(key);
            return file.delete();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean hasEntry(@NotNull K key) {
        try {
            File file = this.getFileForKey(key);
            return file.exists();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    @NotNull
    public D retrieveEntry(@NotNull K key) throws Exception {
        File file = this.getFileForKey(key);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        return (D)this.gson.fromJson((Reader)reader, this.dataType);
    }

    @Override
    @NotNull
    public Collection<D> getAllEntries() throws Exception {
        File[] files = this.directory.listFiles();
        if (files == null || files.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> values = new ArrayList<Object>();
        for (File file : files) {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            values.add(this.gson.fromJson((Reader)reader, this.dataType));
        }
        return ImmutableList.copyOf(values);
    }

    @Override
    @NotNull
    public Collection<D> getAllEntries(@Nullable Consumer<Exception> exceptionConsumer) {
        File[] files = this.directory.listFiles();
        if (files == null || files.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> values = new ArrayList<Object>();
        for (File file : files) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(file));
                values.add(this.gson.fromJson((Reader)reader, this.dataType));
            }
            catch (IOException ex) {
                if (exceptionConsumer == null) continue;
                exceptionConsumer.accept(ex);
            }
        }
        return ImmutableList.copyOf(values);
    }

    @NotNull
    private File getFileForKey(K key) {
        SerializerRegistry registry = this.plugin.getSerializerRegistry();
        KeySerializer<?, ?> serializer = null;
        for (Class<?> clazz : registry.getKeySerializers().keySet()) {
            if (!clazz.isAssignableFrom(key.getClass())) continue;
            serializer = registry.getKeySerializer(clazz);
        }
        if (serializer == null) {
            throw new NullPointerException(String.format("No key serializer registered for type \"%s\"", key.getClass().getName()));
        }
        Object serializedKey = serializer.serialize(key);
        String fileName = serializedKey.toString() + ".json";
        return new File(this.directory, fileName);
    }

    @NotNull
    public static <K, D> Builder<K, D> builder() {
        return new Builder();
    }

    public static final class Builder<K, D> {
        private File directory;
        private Gson gson = Reference.GSON_PRETTY;
        private Class<D> dataType;

        @Contract(value="_ -> this")
        @NotNull
        public Builder<K, D> directory(@NotNull File directory) {
            if (!directory.exists()) {
                directory.mkdirs();
            }
            Validate.isTrue((boolean)directory.isDirectory(), (String)"Must provide a valid directory");
            this.directory = directory;
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder<K, D> gson(@NotNull Gson gson) {
            this.gson = gson;
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder<K, D> dataType(@NotNull Class<D> dataType) {
            this.dataType = dataType;
            return this;
        }

        @NotNull
        public FlatfileDriver<K, D> build(@NotNull AlpinePlugin plugin) {
            Validate.notNull((Object)this.directory, (String)"Directory must not be null");
            Validate.notNull(this.dataType, (String)"Data type must not be null");
            return new FlatfileDriver(plugin, this.directory, this.gson, this.dataType);
        }

        @Deprecated
        @NotNull
        public FlatfileDriver<K, D> build() {
            return this.build(AlpineCore.getInstance());
        }
    }
}

