/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.storage.driver;

import co.crystaldev.alpinecore.AlpinePlugin;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AlpineDriver<K, D> {
    protected final AlpinePlugin plugin;

    public AlpineDriver(@NotNull AlpinePlugin plugin) {
        this.plugin = plugin;
    }

    public abstract boolean persistEntry(@NotNull K var1, @NotNull D var2);

    public boolean persistEntries(@NotNull Map<K, D> entries) {
        boolean success = true;
        for (Map.Entry<K, D> entry : entries.entrySet()) {
            if (this.persistEntry(entry.getKey(), entry.getValue())) continue;
            success = false;
        }
        return success;
    }

    public abstract boolean deleteEntry(@NotNull K var1);

    public abstract boolean hasEntry(@NotNull K var1);

    @NotNull
    public abstract D retrieveEntry(@NotNull K var1) throws Exception;

    @NotNull
    public abstract Collection<D> getAllEntries() throws Exception;

    @NotNull
    public abstract Collection<D> getAllEntries(@Nullable Consumer<Exception> var1);

    public void shutdown() {
    }
}

