/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.config.object.item;

import co.crystaldev.alpinecore.AlpinePlugin;
import co.crystaldev.alpinecore.framework.config.object.item.ConfigItemHelper;
import co.crystaldev.alpinecore.framework.config.object.item.DefinedConfigItem;
import co.crystaldev.alpinecore.framework.config.object.item.VaryingConfigItem;
import co.crystaldev.alpinecore.integration.PlaceholderIntegration;
import co.crystaldev.alpinecore.util.Components;
import co.crystaldev.alpinecore.util.Formatting;
import co.crystaldev.alpinecore.util.ItemHelper;
import com.cryptomorin.xseries.XItemFlag;
import com.cryptomorin.xseries.XMaterial;
import de.exlll.configlib.Polymorphic;
import de.exlll.configlib.PolymorphicTypes;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Polymorphic
@PolymorphicTypes(value={@PolymorphicTypes.Type(type=DefinedConfigItem.class), @PolymorphicTypes.Type(type=VaryingConfigItem.class)})
public interface ConfigItem {
    @Nullable
    public String getName();

    @Nullable
    public List<String> getLore();

    public boolean isEnchanted();

    public int getCount();

    @Nullable
    public Map<String, Object> getAttributes();

    @Nullable
    default public <T> T getAttribute(@NotNull String key, @NotNull Class<T> type) {
        return this.getAttributes() == null ? null : (T)type.cast(this.getAttributes().get(key));
    }

    @Nullable
    default public <T> T getAttribute(@NotNull String key) {
        return (T)(this.getAttributes() == null ? null : this.getAttributes().get(key));
    }

    default public boolean hasAttribute(@NotNull String key) {
        return this.getAttributes() != null && this.getAttributes().containsKey(key);
    }

    @NotNull
    default public ItemStack build(@NotNull AlpinePlugin plugin, @Nullable XMaterial type, int count, @Nullable Function<ItemStack, ItemStack> function, @Nullable OfflinePlayer targetPlayer, @Nullable OfflinePlayer otherPlayer, Object ... placeholders) {
        Map<String, Object> attributes;
        String replacedName;
        if (type == null || !type.isSupported()) {
            type = XMaterial.AIR;
        }
        if (type == XMaterial.AIR) {
            return new ItemStack(Material.AIR);
        }
        PlaceholderIntegration integration = plugin.getActivatable(PlaceholderIntegration.class);
        MiniMessage serializer = plugin.getMiniMessage();
        Map placeholdersMap = placeholders.length == 1 && placeholders[0] instanceof Map ? (Map)placeholders[0] : null;
        String string = replacedName = placeholdersMap != null ? Formatting.placeholders(plugin, this.getName(), (Map<String, Object>)placeholdersMap) : Formatting.placeholders(plugin, this.getName(), placeholders);
        if (integration != null) {
            replacedName = integration.replace(targetPlayer, otherPlayer, true, replacedName);
        }
        Component name = Components.reset().append((Component)serializer.deserialize(replacedName));
        String joinedLore = this.getLore() == null || this.getLore().isEmpty() ? "" : String.join((CharSequence)"\n", this.getLore());
        String string2 = joinedLore = placeholdersMap != null ? Formatting.placeholders(plugin, joinedLore, (Map<String, Object>)placeholdersMap) : Formatting.placeholders(plugin, joinedLore, placeholders);
        if (integration != null) {
            joinedLore = integration.replace(targetPlayer, otherPlayer, true, joinedLore);
        }
        List<Component> lore = Stream.of(joinedLore.split("\n|<br>")).map(v -> v.isEmpty() ? " " : v).map(v -> Components.reset().append((Component)serializer.deserialize(v))).collect(Collectors.toList());
        ItemStack stack = type.parseItem();
        Material parsed = type.parseMaterial();
        count = Math.max(Math.min(parsed.getMaxStackSize(), count), 1);
        stack.setAmount(count);
        ItemHelper.setDisplayName(stack, name);
        ItemHelper.setLore(stack, lore);
        if (this.isEnchanted()) {
            stack.addUnsafeEnchantment(Enchantment.LURE, 1);
            ItemMeta meta = stack.getItemMeta();
            meta.addItemFlags(new ItemFlag[]{XItemFlag.HIDE_ENCHANTS.get()});
            stack.setItemMeta(meta);
        }
        if ((attributes = this.getAttributes()) != null && !attributes.isEmpty()) {
            ConfigItemHelper.applyToItem(stack, attributes);
        }
        if (function != null) {
            stack = function.apply(stack);
        }
        return stack;
    }

    @NotNull
    default public ItemStack build(@NotNull AlpinePlugin plugin, @Nullable XMaterial type, int count, @Nullable Function<ItemStack, ItemStack> function, Object ... placeholders) {
        return this.build(plugin, type, count, function, null, null, placeholders);
    }

    @NotNull
    default public ItemStack build(@NotNull AlpinePlugin plugin, @Nullable XMaterial type, @Nullable Function<ItemStack, ItemStack> function, Object ... placeholders) {
        return this.build(plugin, type, this.getCount(), function, placeholders);
    }

    @NotNull
    default public ItemStack build(@NotNull AlpinePlugin plugin, @Nullable XMaterial type, int count, Object ... placeholders) {
        return this.build(plugin, type, count, null, placeholders);
    }

    @NotNull
    default public ItemStack build(@NotNull AlpinePlugin plugin, @Nullable XMaterial type, Object ... placeholders) {
        return this.build(plugin, type, this.getCount(), null, placeholders);
    }

    @NotNull
    default public ItemStack build(@NotNull AlpinePlugin plugin, @Nullable XMaterial type, @Nullable Function<ItemStack, ItemStack> function, @Nullable OfflinePlayer targetPlayer, @Nullable OfflinePlayer otherPlayer, Object ... placeholders) {
        return this.build(plugin, type, this.getCount(), function, targetPlayer, otherPlayer, placeholders);
    }

    @NotNull
    default public ItemStack build(@NotNull AlpinePlugin plugin, @Nullable XMaterial type, int count, @Nullable OfflinePlayer targetPlayer, @Nullable OfflinePlayer otherPlayer, Object ... placeholders) {
        return this.build(plugin, type, count, (Function<ItemStack, ItemStack>)null, targetPlayer, otherPlayer, placeholders);
    }

    @NotNull
    default public ItemStack build(@NotNull AlpinePlugin plugin, @Nullable XMaterial type, @Nullable OfflinePlayer targetPlayer, @Nullable OfflinePlayer otherPlayer, Object ... placeholders) {
        return this.build(plugin, type, this.getCount(), (Function<ItemStack, ItemStack>)null, targetPlayer, otherPlayer, placeholders);
    }

    @NotNull
    default public ItemStack build(@NotNull AlpinePlugin plugin, @NotNull ItemStack stack, int count, @Nullable Function<ItemStack, ItemStack> function, @Nullable OfflinePlayer targetPlayer, @Nullable OfflinePlayer otherPlayer, Object ... placeholders) {
        Map<String, Object> attributes;
        String replacedName;
        PlaceholderIntegration integration = plugin.getActivatable(PlaceholderIntegration.class);
        MiniMessage serializer = plugin.getMiniMessage();
        Map placeholdersMap = placeholders.length == 1 && placeholders[0] instanceof Map ? (Map)placeholders[0] : null;
        String string = replacedName = placeholdersMap != null ? Formatting.placeholders(plugin, this.getName(), (Map<String, Object>)placeholdersMap) : Formatting.placeholders(plugin, this.getName(), placeholders);
        if (integration != null) {
            replacedName = integration.replace(targetPlayer, otherPlayer, true, replacedName);
        }
        Component name = Components.reset().append((Component)serializer.deserialize(replacedName));
        String joinedLore = this.getLore() == null || this.getLore().isEmpty() ? "" : String.join((CharSequence)"\n", this.getLore());
        String string2 = joinedLore = placeholdersMap != null ? Formatting.placeholders(plugin, joinedLore, (Map<String, Object>)placeholdersMap) : Formatting.placeholders(plugin, joinedLore, placeholders);
        if (integration != null) {
            joinedLore = integration.replace(targetPlayer, otherPlayer, true, joinedLore);
        }
        List<Component> lore = Stream.of(joinedLore.split("\n|<br>")).map(v -> v.isEmpty() ? " " : v).map(v -> Components.reset().append((Component)serializer.deserialize(v))).collect(Collectors.toList());
        stack = stack.clone();
        stack.setAmount(Math.max(Math.min(stack.getMaxStackSize(), count), 1));
        ItemHelper.setDisplayName(stack, name);
        ItemHelper.setLore(stack, lore);
        if (this.isEnchanted()) {
            stack.addUnsafeEnchantment(Enchantment.LURE, 1);
            ItemMeta meta = stack.getItemMeta();
            meta.addItemFlags(new ItemFlag[]{XItemFlag.HIDE_ENCHANTS.get()});
            stack.setItemMeta(meta);
        }
        if ((attributes = this.getAttributes()) != null && !attributes.isEmpty()) {
            ConfigItemHelper.applyToItem(stack, attributes);
        }
        if (function != null) {
            stack = function.apply(stack);
        }
        return stack;
    }

    @NotNull
    default public ItemStack build(@NotNull AlpinePlugin plugin, @NotNull ItemStack stack, int count, @Nullable Function<ItemStack, ItemStack> function, Object ... placeholders) {
        return this.build(plugin, stack, count, function, null, null, placeholders);
    }

    @NotNull
    default public ItemStack build(@NotNull AlpinePlugin plugin, @NotNull ItemStack stack, @Nullable Function<ItemStack, ItemStack> function, Object ... placeholders) {
        return this.build(plugin, stack, this.getCount(), function, placeholders);
    }

    @NotNull
    default public ItemStack build(@NotNull AlpinePlugin plugin, @NotNull ItemStack stack, int count, Object ... placeholders) {
        return this.build(plugin, stack, count, null, placeholders);
    }

    @NotNull
    default public ItemStack build(@NotNull AlpinePlugin plugin, @NotNull ItemStack stack, Object ... placeholders) {
        return this.build(plugin, stack, this.getCount(), null, placeholders);
    }

    @NotNull
    default public ItemStack build(@NotNull AlpinePlugin plugin, @NotNull ItemStack stack, @Nullable Function<ItemStack, ItemStack> function, @Nullable OfflinePlayer targetPlayer, @Nullable OfflinePlayer otherPlayer, Object ... placeholders) {
        return this.build(plugin, stack, this.getCount(), function, targetPlayer, otherPlayer, placeholders);
    }

    @NotNull
    default public ItemStack build(@NotNull AlpinePlugin plugin, @NotNull ItemStack stack, int count, @Nullable OfflinePlayer targetPlayer, @Nullable OfflinePlayer otherPlayer, Object ... placeholders) {
        return this.build(plugin, stack, count, (Function<ItemStack, ItemStack>)null, targetPlayer, otherPlayer, placeholders);
    }

    @NotNull
    default public ItemStack build(@NotNull AlpinePlugin plugin, @NotNull ItemStack stack, @Nullable OfflinePlayer targetPlayer, @Nullable OfflinePlayer otherPlayer, Object ... placeholders) {
        return this.build(plugin, stack, this.getCount(), (Function<ItemStack, ItemStack>)null, targetPlayer, otherPlayer, placeholders);
    }

    @NotNull
    default public ItemStack build(@NotNull AlpinePlugin plugin, int count, @Nullable Function<ItemStack, ItemStack> function, Object ... placeholders) {
        return this.build(plugin, (XMaterial)null, count, function, placeholders);
    }

    @NotNull
    default public ItemStack build(@NotNull AlpinePlugin plugin, @Nullable Function<ItemStack, ItemStack> function, Object ... placeholders) {
        return this.build(plugin, (XMaterial)null, this.getCount(), function, placeholders);
    }

    @NotNull
    default public ItemStack build(@NotNull AlpinePlugin plugin, int count, Object ... placeholders) {
        return this.build(plugin, (XMaterial)null, count, placeholders);
    }

    @NotNull
    default public ItemStack build(@NotNull AlpinePlugin plugin, Object ... placeholders) {
        return this.build(plugin, (XMaterial)null, this.getCount(), placeholders);
    }

    @NotNull
    default public ItemStack build(@NotNull AlpinePlugin plugin, int count, @Nullable Function<ItemStack, ItemStack> function, @Nullable OfflinePlayer targetPlayer, @Nullable OfflinePlayer otherPlayer, Object ... placeholders) {
        return this.build(plugin, (XMaterial)null, count, function, targetPlayer, otherPlayer, placeholders);
    }

    @NotNull
    default public ItemStack build(@NotNull AlpinePlugin plugin, @Nullable Function<ItemStack, ItemStack> function, @Nullable OfflinePlayer targetPlayer, @Nullable OfflinePlayer otherPlayer, Object ... placeholders) {
        return this.build(plugin, (XMaterial)null, this.getCount(), function, targetPlayer, otherPlayer, placeholders);
    }

    @NotNull
    default public ItemStack build(@NotNull AlpinePlugin plugin, int count, @Nullable OfflinePlayer targetPlayer, @Nullable OfflinePlayer otherPlayer, Object ... placeholders) {
        return this.build(plugin, (XMaterial)null, count, targetPlayer, otherPlayer, placeholders);
    }

    @NotNull
    default public ItemStack build(@NotNull AlpinePlugin plugin, @Nullable OfflinePlayer targetPlayer, @Nullable OfflinePlayer otherPlayer, Object ... placeholders) {
        return this.build(plugin, (XMaterial)null, this.getCount(), targetPlayer, otherPlayer, placeholders);
    }

    default public void give(@NotNull AlpinePlugin plugin, @NotNull XMaterial type, @NotNull Player player, int count, @Nullable Function<ItemStack, ItemStack> function, Object ... placeholders) {
        ItemStack item = this.build(plugin, type, count, function, placeholders);
        player.getInventory().addItem(new ItemStack[]{item});
    }

    default public void give(@NotNull AlpinePlugin plugin, @NotNull XMaterial type, @NotNull Player player, @Nullable Function<ItemStack, ItemStack> function, Object ... placeholders) {
        ItemStack item = this.build(plugin, type, this.getCount(), function, placeholders);
        player.getInventory().addItem(new ItemStack[]{item});
    }

    default public void give(@NotNull AlpinePlugin plugin, @NotNull XMaterial type, @NotNull Player player, int count, Object ... placeholders) {
        this.give(plugin, type, player, count, null, placeholders);
    }

    default public void give(@NotNull AlpinePlugin plugin, @NotNull XMaterial type, @NotNull Player player, Object ... placeholders) {
        this.give(plugin, type, player, this.getCount(), null, placeholders);
    }
}

