/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore;

import co.crystaldev.alpinecore.AlpineCore;
import co.crystaldev.alpinecore.framework.Activatable;
import co.crystaldev.alpinecore.framework.Initializable;
import co.crystaldev.alpinecore.framework.command.AlpineArgumentResolver;
import co.crystaldev.alpinecore.framework.command.AlpineCommand;
import co.crystaldev.alpinecore.framework.config.AlpineConfig;
import co.crystaldev.alpinecore.framework.config.AlpinePluginConfig;
import co.crystaldev.alpinecore.framework.config.ConfigManager;
import co.crystaldev.alpinecore.framework.config.object.ConfigMessage;
import co.crystaldev.alpinecore.framework.engine.AlpineEngine;
import co.crystaldev.alpinecore.framework.integration.AlpineIntegration;
import co.crystaldev.alpinecore.framework.storage.KeySerializer;
import co.crystaldev.alpinecore.framework.storage.SerializerRegistry;
import co.crystaldev.alpinecore.framework.teleport.TeleportManager;
import co.crystaldev.alpinecore.framework.ui.UIManager;
import co.crystaldev.alpinecore.handler.BaseSchematicGenerator;
import co.crystaldev.alpinecore.handler.InvalidCommandUsageHandler;
import co.crystaldev.alpinecore.integration.PlaceholderIntegration;
import co.crystaldev.alpinecore.integration.VaultIntegration;
import co.crystaldev.alpinecore.util.ChatColor;
import co.crystaldev.alpinecore.util.SimpleTimer;
import co.crystaldev.alpinecore.util.StyleTagResolver;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import dev.rollczi.litecommands.LiteCommands;
import dev.rollczi.litecommands.LiteCommandsBuilder;
import dev.rollczi.litecommands.adventure.bukkit.platform.LiteAdventurePlatformExtension;
import dev.rollczi.litecommands.argument.ArgumentKey;
import dev.rollczi.litecommands.bukkit.LiteBukkitFactory;
import dev.rollczi.litecommands.bukkit.LiteBukkitMessages;
import dev.rollczi.litecommands.bukkit.LiteBukkitSettings;
import dev.rollczi.litecommands.invalidusage.InvalidUsageHandler;
import dev.rollczi.litecommands.message.LiteMessages;
import dev.rollczi.litecommands.schematic.SchematicFormat;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Predicate;
import java.util.logging.Level;
import lombok.Generated;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AlpinePlugin
extends JavaPlugin
implements Listener {
    protected ConfigManager configManager;
    protected AlpinePluginConfig pluginConfig;
    protected LiteCommands<CommandSender> commandManager;
    private final Set<Activatable> activatables = new CopyOnWriteArraySet<Activatable>();
    private final SerializerRegistry serializerRegistry = new SerializerRegistry();
    private UIManager uiManager;
    private TeleportManager teleportManager;
    private MiniMessage miniMessage = MiniMessage.miniMessage();
    private MiniMessage strictMiniMessage = MiniMessage.builder().strict(true).build();

    public void onStart() {
    }

    public void onStop() {
    }

    public boolean onActivatablePreload(@NotNull String activatableClasspath) {
        return true;
    }

    public void registerSerializers(@NotNull SerializerRegistry serializerRegistry) {
    }

    public void setupCommandManager(@NotNull LiteCommandsBuilder<CommandSender, LiteBukkitSettings, ?> builder) {
    }

    public void setupStyles(@NotNull StyleConsumer styleConsumer) {
    }

    public void setupVariables(@NotNull VariableConsumer variableConsumer) {
    }

    public void setupAlpineConfig(@NotNull AlpinePluginConfig config) {
    }

    @NotNull
    public MiniMessage setupMiniMessage(@NotNull MiniMessage.Builder builder) {
        return builder.build();
    }

    @NotNull
    protected Set<Class<?>> getScannablePackages() {
        return ImmutableSet.of(((Object)((Object)this)).getClass());
    }

    @ApiStatus.Internal
    public final void onEnable() {
        this.log("&e=== ENABLE START ===");
        SimpleTimer timer = new SimpleTimer();
        timer.start();
        this.serializerRegistry.putKeySerializer(Number.class, new KeySerializer.NumberKey());
        this.serializerRegistry.putKeySerializer(String.class, new KeySerializer.StringKey());
        this.serializerRegistry.putKeySerializer(UUID.class, new KeySerializer.UuidKey());
        this.serializerRegistry.putKeySerializer(OfflinePlayer.class, new KeySerializer.PlayerKey());
        this.serializerRegistry.putConfigSerializer(ConfigMessage.class, new ConfigMessage.Adapter());
        this.registerSerializers(this.serializerRegistry);
        this.configManager = new ConfigManager(this, this.serializerRegistry);
        this.uiManager = new UIManager(this);
        this.teleportManager = new TeleportManager(this);
        this.setupAlpinePluginConfig();
        this.activateAll();
        TagResolver resolver = TagResolver.resolver(TagResolver.standard(), new StyleTagResolver(this));
        this.miniMessage = this.setupMiniMessage(MiniMessage.builder().tags(resolver));
        this.strictMiniMessage = this.setupMiniMessage(MiniMessage.builder().tags(resolver).strict(true));
        this.setupCommandManager();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.onStart();
        long startupTime = timer.stop();
        this.log(String.format("&e=== ENABLE &aCOMPLETE&e (&d%dms&e) ===", startupTime));
    }

    @ApiStatus.Internal
    public final void onDisable() {
        this.onStop();
        this.deactivateAll();
        this.uiManager.closeAll();
        if (this.commandManager != null) {
            this.commandManager.unregister();
        }
    }

    @NotNull
    public final AlpinePluginConfig getAlpineConfig() {
        return this.pluginConfig;
    }

    @NotNull
    public final <T extends AlpineConfig> T getConfiguration(@NotNull Class<T> clazz) {
        if (AlpinePluginConfig.class.equals(clazz)) {
            return (T)this.getAlpineConfig();
        }
        return this.configManager.getConfig(clazz);
    }

    public long getCurrentTick() {
        return AlpineCore.TICK_COUNTER.get();
    }

    public void setInvalidCommandUseHandler(@Nullable InvalidUsageHandler<CommandSender> handler) {
        AlpineCore.getInstance().setInvalidCommandUseHandler(handler);
    }

    public final void log(@NotNull String message) {
        this.log(Level.INFO, message);
    }

    public final void log(@NotNull String message, @NotNull Throwable throwable) {
        this.getLogger().log(Level.SEVERE, ChatColor.translateToAnsi(message + "&r", true), throwable);
    }

    public final void log(@NotNull Level level, @NotNull String message) {
        this.getLogger().log(level, ChatColor.translateToAnsi(message + "&r", true));
    }

    public final void addActivatable(Activatable activatable) {
        activatable.activate(this);
        this.activatables.add(activatable);
    }

    public final void removeActivatable(Activatable activatable) {
        if (activatable.canDeactivate()) {
            activatable.deactivate(this);
        }
        this.activatables.remove(activatable);
    }

    @Nullable
    public final <T extends Activatable> T getActivatable(@NotNull Class<T> clazz) {
        for (Activatable activatable : this.activatables) {
            if (!activatable.getClass().equals(clazz)) continue;
            return (T)activatable;
        }
        return null;
    }

    private void activateAll() {
        HashSet classes = new HashSet();
        try {
            for (Class<?> scannablePackage : this.getScannablePackages()) {
                String packageName = scannablePackage.getPackage().getName();
                ClassPath.from((ClassLoader)scannablePackage.getClassLoader()).getAllClasses().stream().filter(clazz -> clazz.getPackageName().contains(packageName)).filter(clazz -> this.onActivatablePreload(clazz.getName())).map(v -> {
                    try {
                        return v.load();
                    }
                    catch (Throwable e) {
                        this.log(Level.FINE, String.format("&cUnable to scan class &d%s&c", v.getName()));
                        return null;
                    }
                }).filter(Objects::nonNull).forEach(classes::add);
            }
            classes.add(PlaceholderIntegration.class);
            classes.add(VaultIntegration.class);
        }
        catch (Exception ex) {
            this.log("&cError scanning classpath", ex);
        }
        this.activate(classes, c -> AlpineConfig.class.isAssignableFrom((Class<?>)c) && !AlpinePluginConfig.class.isAssignableFrom((Class<?>)c));
        this.activate(classes, AlpineIntegration.class::isAssignableFrom);
        this.activate(classes, AlpineEngine.class::isAssignableFrom);
        this.activate(classes, AlpineArgumentResolver.class::isAssignableFrom);
        this.activate(classes, AlpineCommand.class::isAssignableFrom);
        this.activate(classes, c -> !AlpinePluginConfig.class.isAssignableFrom((Class<?>)c));
    }

    private void deactivateAll() {
        for (Activatable activatable : this.activatables) {
            try {
                if (!activatable.canDeactivate()) continue;
                activatable.deactivate(this);
            }
            catch (Exception ex) {
                this.log(String.format("&cError deactivating &d%s", activatable.getClass().getSimpleName()), ex);
            }
        }
        this.activatables.clear();
    }

    private void setupCommandManager() {
        AlpinePluginConfig messages = this.getAlpineConfig();
        AlpineCommand[] commands = (AlpineCommand[])this.activatables.stream().filter(v -> v instanceof AlpineCommand).filter(Activatable::isActive).toArray(AlpineCommand[]::new);
        Object builder = LiteBukkitFactory.builder(this.getName()).self((self, internal) -> self.schematicGenerator(new BaseSchematicGenerator(this, SchematicFormat.angleBrackets(), internal.getPermissionService(), internal.getParserRegistry()))).extension(new LiteAdventurePlatformExtension(BukkitAudiences.create((Plugin)this)), config -> config.miniMessage(true).legacyColor(true).colorizeArgument(true).serializer(this.miniMessage)).settings(settings -> settings.nativePermissions(true).fallbackPrefix(this.getName().toLowerCase(Locale.ROOT))).commands(commands).invalidUsage(new InvalidCommandUsageHandler(this)).message(LiteMessages.MISSING_PERMISSIONS, permission -> messages.missingPermissions.buildString(this, "permission", permission)).message(LiteMessages.INVALID_NUMBER, input -> messages.invalidNumber.buildString(this, "input", input)).message(LiteMessages.INSTANT_INVALID_FORMAT, input -> messages.invalidInstant.buildString(this, "input", input)).message(LiteBukkitMessages.WORLD_NOT_EXIST, input -> messages.invalidWorld.buildString(this, "input", input)).message(LiteBukkitMessages.LOCATION_INVALID_FORMAT, input -> messages.invalidLocation.buildString(this, "input", input)).message(LiteBukkitMessages.PLAYER_NOT_FOUND, input -> messages.playerNotFound.buildString(this, "player", input)).message(LiteBukkitMessages.PLAYER_ONLY, input -> messages.playerOnly.buildString(this, new Object[0]));
        this.setupCommandManager((LiteCommandsBuilder<CommandSender, LiteBukkitSettings, ?>)builder);
        AlpineCore.getInstance().forEachResolver(resolver -> {
            String key = resolver.getKey();
            if (key == null) {
                builder.argument(resolver.getType(), resolver);
            } else {
                builder.argument(resolver.getType(), ArgumentKey.of(key), resolver);
            }
        });
        for (AlpineCommand command : commands) {
            command.setupCommandManager((LiteCommandsBuilder<CommandSender, LiteBukkitSettings, ?>)builder);
        }
        this.commandManager = builder.build();
    }

    private void activate(@NotNull Set<Class<?>> classes, @NotNull Predicate<Class<?>> classPredicate) {
        for (Class<?> clazz : new HashSet(classes)) {
            if (!Activatable.class.isAssignableFrom(clazz) || Modifier.isAbstract(clazz.getModifiers()) || !classPredicate.test(clazz)) continue;
            try {
                Activatable activatable;
                try {
                    Constructor<?> constructor = clazz.getDeclaredConstructor(AlpinePlugin.class);
                    constructor.setAccessible(true);
                    activatable = (Activatable)constructor.newInstance(new Object[]{this});
                }
                catch (NoSuchMethodException ex) {
                    Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    activatable = (Activatable)constructor.newInstance(new Object[0]);
                }
                if (activatable instanceof Initializable) {
                    Initializable initializable = (Initializable)((Object)activatable);
                    if (initializable.init()) {
                        activatable.activate(this);
                        this.activatables.add(activatable);
                    }
                } else {
                    activatable.activate(this);
                    this.activatables.add(activatable);
                }
            }
            catch (Exception ex) {
                this.log(String.format("&cError activating &d%s", clazz.getSimpleName()), ex);
            }
            classes.remove(clazz);
        }
    }

    private void setupAlpinePluginConfig() {
        Plugin plugin;
        AlpinePluginConfig config = new AlpinePluginConfig();
        this.setupStyles((tag, style) -> config.styles.put(tag, style));
        this.setupVariables((name, variable) -> config.variables.put(name, variable));
        this.setupAlpineConfig(config);
        this.pluginConfig = this.configManager.loadConfig(config);
        if (this.pluginConfig.overrideWith != null && !this.pluginConfig.overrideWith.equals(this.getName()) && (plugin = Bukkit.getPluginManager().getPlugin(this.pluginConfig.overrideWith)) instanceof AlpinePlugin) {
            AlpinePlugin other = (AlpinePlugin)plugin;
            this.log(String.format("&aReplacing AlpinePlugin config with &d%s", other.getName()));
            this.pluginConfig = other.pluginConfig;
        }
    }

    @EventHandler
    private void onPluginLoad(PluginEnableEvent event) {
        if (!(event.getPlugin() instanceof AlpinePlugin)) {
            return;
        }
        AlpinePlugin other = (AlpinePlugin)event.getPlugin();
        if (other.getName().equalsIgnoreCase(this.pluginConfig.overrideWith)) {
            this.log(String.format("&aReplacing AlpinePlugin config with &d%s", other.getName()));
            this.pluginConfig = other.pluginConfig;
        }
    }

    @Generated
    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    @Generated
    public AlpinePluginConfig getPluginConfig() {
        return this.pluginConfig;
    }

    @Generated
    public LiteCommands<CommandSender> getCommandManager() {
        return this.commandManager;
    }

    @Generated
    public Set<Activatable> getActivatables() {
        return this.activatables;
    }

    @Generated
    public SerializerRegistry getSerializerRegistry() {
        return this.serializerRegistry;
    }

    @Generated
    public UIManager getUiManager() {
        return this.uiManager;
    }

    @Generated
    public TeleportManager getTeleportManager() {
        return this.teleportManager;
    }

    @Generated
    public MiniMessage getMiniMessage() {
        return this.miniMessage;
    }

    @Generated
    public MiniMessage getStrictMiniMessage() {
        return this.strictMiniMessage;
    }

    @FunctionalInterface
    public static interface StyleConsumer {
        public void addStyle(@NotNull String var1, @NotNull String var2);
    }

    @FunctionalInterface
    public static interface VariableConsumer {
        public void addVariable(@NotNull String var1, @NotNull String var2);
    }
}

