/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore;

import co.crystaldev.alpinecore.AlpinePlugin;
import co.crystaldev.alpinecore.event.ServerTickEvent;
import co.crystaldev.alpinecore.framework.command.AlpineArgumentResolver;
import co.crystaldev.alpinecore.framework.teleport.AlpineTeleportHandler;
import dev.rollczi.litecommands.invalidusage.InvalidUsageHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class AlpineCore
extends AlpinePlugin {
    private static AlpineCore instance;
    static final AtomicLong TICK_COUNTER;
    private final Map<AlpinePlugin, Set<AlpineArgumentResolver<?>>> argumentResolvers;
    private InvalidUsageHandler<CommandSender> invalidCommandUsageHandler;

    public AlpineCore() {
        instance = this;
        this.argumentResolvers = new HashMap();
    }

    @Override
    public void onStart() {
        ServerTickEvent event = new ServerTickEvent();
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> {
            Bukkit.getPluginManager().callEvent((Event)event);
            event.setTick(TICK_COUNTER.incrementAndGet());
        }, 0L, 1L);
        this.getTeleportManager().registerHandler(new AlpineTeleportHandler());
    }

    @EventHandler
    private void onPluginDisable(PluginDisableEvent event) {
        if (event.getPlugin() instanceof AlpinePlugin) {
            AlpinePlugin plugin = (AlpinePlugin)event.getPlugin();
            this.unregisterArgumentResolvers(plugin);
        }
    }

    public void registerArgumentResolver(@NotNull AlpinePlugin plugin, @NotNull AlpineArgumentResolver<?> resolver) {
        this.argumentResolvers.computeIfAbsent(plugin, k -> new HashSet()).add(resolver);
    }

    public void unregisterArgumentResolvers(@NotNull AlpinePlugin plugin) {
        this.argumentResolvers.remove((Object)plugin);
    }

    public void forEachResolver(@NotNull Consumer<AlpineArgumentResolver> resolverConsumer) {
        this.argumentResolvers.forEach((plugin, resolvers) -> resolvers.forEach(resolverConsumer));
    }

    @Override
    public void setInvalidCommandUseHandler(@Nullable InvalidUsageHandler<CommandSender> handler) {
        this.invalidCommandUsageHandler = handler;
    }

    @Generated
    public static AlpineCore getInstance() {
        return instance;
    }

    @Generated
    public InvalidUsageHandler<CommandSender> getInvalidCommandUsageHandler() {
        return this.invalidCommandUsageHandler;
    }

    static {
        TICK_COUNTER = new AtomicLong();
    }
}

