/*
 * Decompiled with CFR 0.152.
 */
package dev.rollczi.litecommands.suggestion;

import dev.rollczi.litecommands.shared.IterableMutableArray;
import dev.rollczi.litecommands.suggestion.Suggestion;
import dev.rollczi.litecommands.suggestion.SuggestionResultCollector;
import dev.rollczi.litecommands.suggestion.SuggestionResultTooltipCollector;
import dev.rollczi.litecommands.util.StringUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;

public class SuggestionResult {
    private final Set<Suggestion> suggestions;

    private SuggestionResult(Set<Suggestion> suggestions) {
        this.suggestions = suggestions;
    }

    public void addAll(Collection<Suggestion> suggestions) {
        this.suggestions.addAll(suggestions);
    }

    public void add(Suggestion suggestion) {
        this.suggestions.add(suggestion);
    }

    @ApiStatus.Internal
    public void remove(Suggestion suggestion) {
        this.suggestions.remove(suggestion);
    }

    @ApiStatus.Internal
    public void clear() {
        this.suggestions.clear();
    }

    public void addAll(SuggestionResult result) {
        this.suggestions.addAll(result.suggestions);
    }

    public SuggestionResult filterBy(Suggestion suggestion) {
        String multilevel = suggestion.multilevel();
        int levels = suggestion.lengthMultilevel();
        Set<Suggestion> filtered = this.suggestions.stream().filter(current -> StringUtil.startsWithIgnoreCase(current.multilevel(), multilevel)).map(suggestion1 -> suggestion1.deleteLeft(levels - 1)).collect(Collectors.toSet());
        return new SuggestionResult(filtered);
    }

    public Set<Suggestion> getSuggestions() {
        return Collections.unmodifiableSet(this.suggestions);
    }

    public List<String> asMultiLevelList() {
        return this.suggestions.stream().map(Suggestion::multilevel).collect(Collectors.toList());
    }

    public SuggestionResult appendLeft(String ... suggestions) {
        HashSet<Suggestion> parsedSuggestions = new HashSet<Suggestion>();
        for (Suggestion suggestion : this.suggestions) {
            parsedSuggestions.add(suggestion.appendLeft(suggestions));
        }
        return new SuggestionResult(parsedSuggestions);
    }

    public SuggestionResult appendLeft(Iterable<String> suggestions) {
        HashSet<Suggestion> parsedSuggestions = new HashSet<Suggestion>();
        for (Suggestion suggestion : this.suggestions) {
            parsedSuggestions.add(suggestion.appendLeft(suggestions));
        }
        return new SuggestionResult(parsedSuggestions);
    }

    @ApiStatus.Experimental
    public SuggestionResult appendLeftDirectly(String partToAppend) {
        HashSet<Suggestion> parsedSuggestions = new HashSet<Suggestion>();
        for (Suggestion suggestion : this.suggestions) {
            parsedSuggestions.add(Suggestion.of(partToAppend + suggestion.multilevel(), suggestion.tooltip()));
        }
        return new SuggestionResult(parsedSuggestions);
    }

    public SuggestionResult appendRight(Iterable<String> suggestions) {
        HashSet<Suggestion> parsedSuggestions = new HashSet<Suggestion>();
        for (Suggestion suggestion : this.suggestions) {
            parsedSuggestions.add(suggestion.appendRight(suggestions));
        }
        return new SuggestionResult(parsedSuggestions);
    }

    public SuggestionResult appendRight(String ... suggestions) {
        HashSet<Suggestion> parsedSuggestions = new HashSet<Suggestion>();
        for (Suggestion suggestion : this.suggestions) {
            parsedSuggestions.add(suggestion.appendRight(suggestions));
        }
        return new SuggestionResult(parsedSuggestions);
    }

    public static SuggestionResult of(String ... suggestions) {
        return SuggestionResult.of(new IterableMutableArray<String>(suggestions));
    }

    public static SuggestionResult empty() {
        return new SuggestionResult(new HashSet<Suggestion>());
    }

    public static SuggestionResult of(Iterable<String> suggestions) {
        HashSet<Suggestion> parsedSuggestions = new HashSet<Suggestion>();
        for (String suggestion : suggestions) {
            parsedSuggestions.add(Suggestion.of(suggestion));
        }
        return new SuggestionResult(parsedSuggestions);
    }

    public static SuggestionResult from(Suggestion ... suggestions) {
        return SuggestionResult.from(new IterableMutableArray<Suggestion>(suggestions));
    }

    public static SuggestionResult from(Iterable<Suggestion> suggestions) {
        HashSet<Suggestion> checkedSuggestions = new HashSet<Suggestion>();
        for (Suggestion suggestion : suggestions) {
            checkedSuggestions.add(suggestion);
        }
        return new SuggestionResult(checkedSuggestions);
    }

    public static SuggestionResultCollector collector() {
        return new SuggestionResultCollector();
    }

    @ApiStatus.Experimental
    public static <T> SuggestionResultTooltipCollector<T> collector(Function<T, String> suggestion) {
        return new SuggestionResultTooltipCollector<Object>(suggestion, t -> "");
    }

    @ApiStatus.Experimental
    public static <T> SuggestionResultTooltipCollector<T> collector(Function<T, String> suggestion, Function<T, String> tooltip) {
        return new SuggestionResultTooltipCollector<T>(suggestion, tooltip);
    }
}

