/*
 * Decompiled with CFR 0.152.
 */
package dev.rollczi.litecommands.shared;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IterableReferences<E>
implements Iterable<E> {
    private final List<Iterable<E>> collections;

    private IterableReferences(List<Iterable<E>> collections) {
        this.collections = collections;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new MergedIterator();
    }

    @SafeVarargs
    public static <E> IterableReferences<E> of(Iterable<E> ... collections) {
        return new IterableReferences<E>(Arrays.asList(collections));
    }

    private class MergedIterator
    implements Iterator<E> {
        private final Iterator<Iterable<E>> collectionIterator;
        private Iterator<E> currentIterator;

        private MergedIterator() {
            this.collectionIterator = IterableReferences.this.collections.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.currentIterator != null && this.currentIterator.hasNext()) {
                return true;
            }
            while (this.collectionIterator.hasNext()) {
                this.currentIterator = this.collectionIterator.next().iterator();
                if (!this.currentIterator.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public E next() {
            return this.currentIterator.next();
        }
    }
}

