/*
 * Decompiled with CFR 0.152.
 */
package dev.rollczi.litecommands.schematic;

import dev.rollczi.litecommands.argument.Argument;
import dev.rollczi.litecommands.argument.parser.Parser;
import dev.rollczi.litecommands.argument.parser.ParserRegistry;
import dev.rollczi.litecommands.command.CommandRoute;
import dev.rollczi.litecommands.command.executor.CommandExecutor;
import dev.rollczi.litecommands.permission.PermissionService;
import dev.rollczi.litecommands.range.Range;
import dev.rollczi.litecommands.schematic.Schematic;
import dev.rollczi.litecommands.schematic.SchematicFastFormat;
import dev.rollczi.litecommands.schematic.SchematicGenerator;
import dev.rollczi.litecommands.schematic.SchematicInput;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class SchematicFastGenerator<SENDER>
implements SchematicGenerator<SENDER> {
    private static final String SEPARATOR = " ";
    protected final SchematicFastFormat fastFormat;
    protected final PermissionService permissionService;
    protected final ParserRegistry<SENDER> parserRegistry;

    public SchematicFastGenerator(SchematicFastFormat fastFormat, PermissionService permissionService, ParserRegistry<SENDER> parserRegistry) {
        this.fastFormat = fastFormat;
        this.permissionService = permissionService;
        this.parserRegistry = parserRegistry;
    }

    @Override
    public Schematic generate(SchematicInput<SENDER> schematicInput) {
        return new Schematic(this.generateRaw(schematicInput));
    }

    protected Set<String> generateRaw(SchematicInput<SENDER> schematicInput) {
        CommandExecutor<SENDER> executor = schematicInput.getExecutor();
        StringBuilder builder = new StringBuilder(this.fastFormat.prefix());
        for (CommandRoute<SENDER> route : schematicInput.collectRoutes()) {
            builder.append(route.getName()).append(SEPARATOR);
        }
        String base = builder.toString();
        Set<String> routeScheme = this.generateRoute(schematicInput, schematicInput.getLastRoute(), base);
        if (executor != null) {
            routeScheme.add(this.generateExecutor(base, schematicInput, executor));
        }
        return routeScheme;
    }

    protected Set<String> generateRoute(SchematicInput<SENDER> input, CommandRoute<SENDER> route, String base) {
        LinkedHashSet<String> schematics = new LinkedHashSet<String>();
        for (CommandRoute<SENDER> commandRoute : route.getChildren()) {
            schematics.addAll(this.generateRoute(input, commandRoute, base + commandRoute.getName() + SEPARATOR));
        }
        for (CommandExecutor commandExecutor : route.getExecutors()) {
            if (!this.isVisible(input, commandExecutor)) continue;
            schematics.add(this.generateExecutor(base, input, commandExecutor));
        }
        return schematics;
    }

    protected String generateExecutor(String base, SchematicInput<SENDER> input, CommandExecutor<SENDER> executor) {
        StringBuilder builder = new StringBuilder(base);
        for (Argument<?> argument : executor.getArguments()) {
            String argumentName = this.generateArgumentName(input, argument);
            builder.append(this.generateArgumentFormat(input, argument, argumentName)).append(SEPARATOR);
        }
        if (!executor.getArguments().isEmpty()) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    protected String generateArgumentFormat(SchematicInput<SENDER> input, Argument<?> argument, String argumentName) {
        return this.isOptional(input, argument) ? this.fastFormat.optionalArgumentStart().concat(argumentName).concat(this.fastFormat.optionalArgumentEnd()) : this.fastFormat.argumentStart().concat(argumentName).concat(this.fastFormat.argumentEnd());
    }

    protected String generateArgumentName(SchematicInput<SENDER> input, Argument<?> argument) {
        return argument.getName();
    }

    protected boolean isVisible(SchematicInput<SENDER> input, CommandExecutor<SENDER> executor) {
        return this.permissionService.validate(input.getInvocation().platformSender(), executor).isPermitted();
    }

    protected <T> boolean isOptional(SchematicInput<SENDER> input, Argument<T> argument) {
        Range range;
        Parser<SENDER, T> parser = this.parserRegistry.getParserOrNull(argument);
        if (parser != null && (range = parser.getRange(argument)).getMin() == 0) {
            return true;
        }
        return argument.hasDefaultValue();
    }
}

