/*
 * Decompiled with CFR 0.152.
 */
package dev.rollczi.litecommands.priority;

import dev.rollczi.litecommands.priority.Prioritized;
import dev.rollczi.litecommands.priority.PrioritizedList;
import dev.rollczi.litecommands.priority.PriorityLevel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class MutablePrioritizedList<E extends Prioritized>
implements PrioritizedList<E> {
    private final TreeMap<PriorityLevel, Entry<E>> priorities = new TreeMap(Comparator.reverseOrder());
    private final HashSet<E> elements = new HashSet();

    public MutablePrioritizedList() {
    }

    public MutablePrioritizedList(Iterable<E> elements) {
        for (Prioritized element : elements) {
            this.add(element);
        }
    }

    public void add(E element) {
        Entry entry = this.priorities.computeIfAbsent(element.getPriority(), priority -> new Entry((PriorityLevel)priority));
        entry.elements.add(element);
        this.elements.add(element);
    }

    public void remove(E element) {
        Entry<E> entry = this.priorities.get(element.getPriority());
        if (entry != null) {
            ((Entry)entry).elements.remove(element);
            if (((Entry)entry).elements.isEmpty()) {
                this.priorities.remove(element.getPriority());
            }
        }
        this.elements.remove(element);
    }

    public void clear() {
        this.priorities.clear();
        this.elements.clear();
    }

    @Override
    public boolean contains(E element) {
        return this.elements.contains(element);
    }

    @Override
    public boolean isEmpty() {
        return this.priorities.isEmpty();
    }

    @Override
    public int size() {
        return this.priorities.values().stream().mapToInt(entry -> ((Entry)entry).elements.size()).sum();
    }

    @Override
    public E first() {
        if (this.priorities.isEmpty()) {
            throw new IllegalStateException("PrioritySet is empty");
        }
        Entry<E> entry = this.priorities.firstEntry().getValue();
        return (E)((Prioritized)((Entry)entry).elements.get(0));
    }

    @Override
    public E last() {
        if (this.priorities.isEmpty()) {
            throw new IllegalStateException("PrioritySet is empty");
        }
        Entry<E> entry = this.priorities.lastEntry().getValue();
        return (E)((Prioritized)((Entry)entry).elements.get(((Entry)entry).elements.size() - 1));
    }

    @Override
    public Stream<E> stream() {
        return this.priorities.values().stream().flatMap(entry -> ((Entry)entry).elements.stream());
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.priorities.values().stream().flatMap(entry -> ((Entry)entry).elements.stream()).iterator();
    }

    private static class Entry<E>
    implements Prioritized {
        private final PriorityLevel priority;
        private final List<E> elements = new ArrayList();

        private Entry(PriorityLevel priority) {
            this.priority = priority;
        }

        @Override
        public PriorityLevel getPriority() {
            return this.priority;
        }
    }
}

