/*
 * Decompiled with CFR 0.152.
 */
package dev.rollczi.litecommands.argument.parser;

import dev.rollczi.litecommands.argument.parser.ParseResult;
import dev.rollczi.litecommands.requirement.RequirementCondition;
import dev.rollczi.litecommands.requirement.RequirementResult;
import dev.rollczi.litecommands.shared.FailedReason;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParseCompletedResult<EXPECTED>
implements ParseResult<EXPECTED>,
RequirementResult<EXPECTED> {
    static final ParseResult<?> NULL_SUCCESS = new ParseCompletedResult<Object>(null, null, true, Collections.emptyList());
    @Nullable
    private final EXPECTED successfulResult;
    @Nullable
    private final FailedReason failedResult;
    private final List<RequirementCondition> conditions;
    private final boolean nullable;

    ParseCompletedResult(@Nullable EXPECTED successfulResult, @Nullable FailedReason failedResult, boolean nullable, List<RequirementCondition> conditions) {
        this.conditions = conditions;
        if (successfulResult != null && failedResult != null) {
            throw new IllegalArgumentException("Cannot be both successful and failed");
        }
        if (successfulResult == null && !nullable && failedResult == null) {
            throw new IllegalArgumentException("Cannot be both empty");
        }
        this.nullable = nullable;
        this.successfulResult = successfulResult;
        this.failedResult = failedResult;
    }

    @Override
    public boolean isSuccessful() {
        return this.successfulResult != null;
    }

    @Override
    public boolean isSuccessfulNull() {
        return this.nullable && this.successfulResult == null;
    }

    @Override
    public boolean isFailed() {
        return this.failedResult != null;
    }

    @Override
    @NotNull
    public EXPECTED getSuccess() {
        if (this.successfulResult == null) {
            throw new IllegalStateException("Cannot get successful result when it is empty");
        }
        return this.successfulResult;
    }

    @Override
    @NotNull
    public Object getFailedReason() {
        if (this.failedResult == null) {
            throw new IllegalStateException("Cannot get failed reason when it is empty");
        }
        return this.failedResult.getReason();
    }

    @Override
    @NotNull
    public List<RequirementCondition> getConditions() {
        return this.conditions;
    }

    @Override
    @ApiStatus.Experimental
    public <R> ParseResult<R> map(Function<EXPECTED, R> mapper) {
        if (this.isFailed()) {
            return this;
        }
        return ParseResult.success(mapper.apply(this.getSuccess()));
    }

    @Override
    public ParseResult<EXPECTED> mapFailure(Function<Object, ParseResult<EXPECTED>> mapper) {
        if (this.isFailed()) {
            return mapper.apply(this.failedResult.getReason());
        }
        return this;
    }

    @Override
    @ApiStatus.Experimental
    public <R> ParseResult<R> flatMap(Function<EXPECTED, ParseResult<R>> mapper) {
        if (this.isFailed()) {
            return ParseResult.failure(this.failedResult);
        }
        return mapper.apply(this.getSuccess());
    }

    @Override
    public ParseCompletedResult<EXPECTED> whenSuccessful(Consumer<EXPECTED> action) {
        if (this.isSuccessful()) {
            action.accept(this.getSuccess());
        }
        return this;
    }

    @Override
    public ParseCompletedResult<EXPECTED> whenFailed(Consumer<FailedReason> action) {
        if (this.isFailed()) {
            action.accept(this.failedResult);
        }
        return this;
    }

    @Override
    public CompletableFuture<ParseCompletedResult<EXPECTED>> asFuture() {
        return CompletableFuture.completedFuture(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParseCompletedResult that = (ParseCompletedResult)o;
        return Objects.equals(this.successfulResult, that.successfulResult) && Objects.equals(this.failedResult, that.failedResult);
    }

    public int hashCode() {
        return Objects.hash(this.successfulResult, this.failedResult);
    }

    public String toString() {
        if (this.isSuccessful()) {
            return "ParseResult{successful=" + this.successfulResult + '}';
        }
        if (this.isSuccessfulNull()) {
            return "ParseResult{successful=null}";
        }
        return "ParseResult{failed=" + this.failedResult + '}';
    }
}

