/*
 * Decompiled with CFR 0.152.
 */
package dev.rollczi.litecommands.annotations.priority;

import dev.rollczi.litecommands.priority.PriorityLevel;

public final class PriorityValue {
    public static final int NONE = Integer.MIN_VALUE;
    public static final int LOWEST = -1000;
    public static final int VERY_LOW = -500;
    public static final int LOW = -100;
    public static final int NORMAL_MINUS = -50;
    public static final int NORMAL = 0;
    public static final int NORMAL_PLUS = 50;
    public static final int HIGH = 100;
    public static final int VERY_HIGH = 500;
    public static final int HIGHEST = 1000;
    public static final int MAX = Integer.MAX_VALUE;

    private PriorityValue() {
    }

    public static PriorityLevel toPriorityLevel(int value) {
        switch (value) {
            case -2147483648: {
                return PriorityLevel.NONE;
            }
            case -1000: {
                return PriorityLevel.LOWEST;
            }
            case -500: {
                return PriorityLevel.VERY_LOW;
            }
            case -100: {
                return PriorityLevel.LOW;
            }
            case -50: {
                return PriorityLevel.NORMAL_MINUS;
            }
            case 0: {
                return PriorityLevel.NORMAL;
            }
            case 50: {
                return PriorityLevel.NORMAL_PLUS;
            }
            case 100: {
                return PriorityLevel.HIGH;
            }
            case 500: {
                return PriorityLevel.VERY_HIGH;
            }
            case 1000: {
                return PriorityLevel.HIGHEST;
            }
            case 0x7FFFFFFF: {
                return PriorityLevel.MAX;
            }
        }
        return new PriorityLevel("CUSTOM-" + value, value);
    }
}

