/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.util;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class UuidTypeAdapter
extends TypeAdapter<UUID> {
    public void write(JsonWriter out, UUID value) throws IOException {
        out.value(UuidTypeAdapter.fromUUID(value));
    }

    public UUID read(JsonReader in) throws IOException {
        return UuidTypeAdapter.fromString(in.nextString());
    }

    @NotNull
    public static String fromUUID(@NotNull UUID value) {
        return value.toString().replace("-", "");
    }

    @NotNull
    public static UUID fromString(@NotNull String input) {
        return UUID.fromString(input.replaceFirst("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5"));
    }
}

