/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Observable<T> {
    protected T value;
    protected final Map<Object, Object> observers;

    protected Observable(T initial) {
        this.value = initial;
        this.observers = new HashMap<Object, Object>();
    }

    @NotNull
    public static <T> Observable<T> of(@Nullable T initial) {
        return new Observable<T>(initial);
    }

    public T get() {
        return this.value;
    }

    public void set(@Nullable T newValue) {
        this.set(newValue, false);
    }

    public void set(@Nullable T newValue, boolean forceNotify) {
        T oldValue = this.value;
        this.value = newValue;
        if (forceNotify || !Objects.equals(this.value, oldValue)) {
            this.notifyObservers(newValue, oldValue);
        }
    }

    public void observe(@NotNull Object key, @NotNull Consumer<T> observer) {
        this.observers.put(key, observer);
    }

    public void observe(@NotNull Object key, @NotNull BiConsumer<T, T> observer) {
        this.observers.put(key, observer);
    }

    public void removeObserver(@NotNull Object key) {
        this.observers.remove(key);
    }

    public void notifyObservers() {
        this.notifyObservers(this.value, this.value);
    }

    protected void notifyObservers(T value, T oldValue) {
        for (Object observer : this.observers.values()) {
            if (observer instanceof Consumer) {
                ((Consumer)observer).accept(value);
                continue;
            }
            if (!(observer instanceof BiConsumer)) continue;
            ((BiConsumer)observer).accept(value, oldValue);
        }
    }
}

