/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.ui.handler;

import co.crystaldev.alpinecore.framework.config.object.item.DefinedConfigItem;
import co.crystaldev.alpinecore.framework.ui.UIContext;
import co.crystaldev.alpinecore.framework.ui.element.Element;
import co.crystaldev.alpinecore.framework.ui.event.ActionResult;
import co.crystaldev.alpinecore.framework.ui.event.UIEventBus;
import co.crystaldev.alpinecore.framework.ui.event.type.ClickEvent;
import co.crystaldev.alpinecore.framework.ui.event.type.DragEvent;
import co.crystaldev.alpinecore.framework.ui.handler.UIHandler;
import co.crystaldev.alpinecore.framework.ui.interaction.ClickContext;
import co.crystaldev.alpinecore.framework.ui.interaction.ClickProperties;
import co.crystaldev.alpinecore.framework.ui.interaction.DropContext;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericUIHandler
extends UIHandler {
    private static final GenericUIHandler INSTANCE = new GenericUIHandler();

    @NotNull
    public static GenericUIHandler getInstance() {
        return INSTANCE;
    }

    @Override
    @Nullable
    public Element createElement(@NotNull UIContext context, @NotNull String key, @Nullable DefinedConfigItem definition) {
        return null;
    }

    @Override
    public void registerEvents(@NotNull UIEventBus bus) {
        bus.register(DragEvent.class, (byte)50, (ctx, event) -> {
            InventoryDragEvent handle = event.getHandle();
            ClickType type = handle.getType() == DragType.EVEN ? ClickType.LEFT : ClickType.RIGHT;
            InventoryView view = handle.getView();
            Inventory top = view.getTopInventory();
            ActionResult result = ActionResult.PASS;
            Map items = handle.getNewItems();
            for (Map.Entry entry : items.entrySet()) {
                InventoryAction action;
                ClickContext handledClick;
                int index = (Integer)entry.getKey();
                ItemStack item = (ItemStack)entry.getValue();
                if (index >= top.getSize() || (handledClick = GenericUIHandler.handleClick(ctx, index, type, action = item.getAmount() > 1 ? InventoryAction.PLACE_SOME : InventoryAction.PLACE_ONE, item)) == null || handledClick.result() == ActionResult.PASS) continue;
                result = handledClick.result();
            }
            return result;
        });
        bus.register(ClickEvent.class, (byte)50, (ctx, event) -> {
            InventoryClickEvent handle = event.getHandle();
            if (!handle.getInventory().equals((Object)ctx.inventory())) {
                return ActionResult.PASS;
            }
            InventoryView view = handle.getView();
            Inventory top = view.getTopInventory();
            Inventory clicked = handle.getClickedInventory();
            ClickType type = handle.getClick();
            InventoryAction action = handle.getAction();
            ActionResult result = ActionResult.PASS;
            switch (action) {
                case UNKNOWN: {
                    result = ActionResult.SUCCESS;
                    break;
                }
                case DROP_ALL_CURSOR: 
                case DROP_ONE_CURSOR: {
                    DropContext dropContext = new DropContext(type, action, handle.getCursor(), result);
                    ctx.ui().getHandler().dropped(ctx, dropContext);
                    result = dropContext.result();
                    break;
                }
                case COLLECT_TO_CURSOR: {
                    if (top.equals((Object)clicked)) break;
                    result = GenericUIHandler.handleCollectClick(ctx, handle, top, type, action, result);
                    break;
                }
                case NOTHING: 
                case DROP_ALL_SLOT: 
                case DROP_ONE_SLOT: 
                case HOTBAR_MOVE_AND_READD: 
                case HOTBAR_SWAP: 
                case SWAP_WITH_CURSOR: 
                case PLACE_ALL: 
                case PLACE_SOME: 
                case PLACE_ONE: 
                case PICKUP_ALL: 
                case PICKUP_SOME: 
                case PICKUP_HALF: 
                case PICKUP_ONE: {
                    ActionResult handledClick;
                    if (!top.equals((Object)clicked) || (handledClick = GenericUIHandler.handleClick(ctx, handle, handle.getSlot())) == ActionResult.PASS) break;
                    result = handledClick;
                    break;
                }
                case MOVE_TO_OTHER_INVENTORY: {
                    if (top.equals((Object)clicked)) {
                        ActionResult handledClick = GenericUIHandler.handleClick(ctx, handle, handle.getSlot());
                        if (handledClick == ActionResult.PASS) break;
                        result = handledClick;
                        break;
                    }
                    result = GenericUIHandler.handleShiftClick(ctx, handle, top, type, action, result);
                }
            }
            return result;
        });
    }

    @NotNull
    private static ActionResult handleClick(@NotNull UIContext context, @NotNull InventoryClickEvent event, int slot) {
        ClickContext clickContext = GenericUIHandler.handleClick(context, slot, event.getClick(), event.getAction(), event.getCursor());
        if (clickContext == null) {
            return ActionResult.PASS;
        }
        if (clickContext.consumedItem()) {
            event.setCursor(null);
        }
        return clickContext.result();
    }

    @Nullable
    private static ClickContext handleClick(@NotNull UIContext context, int slot, @NotNull ClickType type, @NotNull InventoryAction action, @Nullable ItemStack clicked) {
        ActionResult result = ActionResult.PASS;
        for (Element element : context.getElements()) {
            if (element.getPosition().getSlot() != slot) continue;
            ClickProperties properties = element.getClickProperties();
            if (!properties.isAllowed(type) || !properties.isAllowed(action)) {
                result = ActionResult.CANCEL;
            }
            ClickContext clickContext = new ClickContext(type, action, clicked, result);
            element.clicked(clickContext);
            return clickContext;
        }
        return null;
    }

    @NotNull
    private static ActionResult handleCollectClick(@NotNull UIContext ctx, @NotNull InventoryClickEvent event, @NotNull Inventory top, @NotNull ClickType type, @NotNull InventoryAction action, @NotNull ActionResult result) {
        ItemStack moving = event.getCursor();
        Material cursorType = moving.getType();
        int inventorySize = top.getSize();
        int remainingAmount = cursorType.getMaxStackSize() - moving.getAmount();
        int nextSlot = 0;
        while (remainingAmount > 0 && nextSlot < inventorySize && result == ActionResult.PASS) {
            ItemStack item = top.getItem(nextSlot);
            if (!moving.isSimilar(item)) {
                ++nextSlot;
                continue;
            }
            int slotAmount = Math.min(item.getAmount(), remainingAmount);
            remainingAmount -= slotAmount;
            ItemStack adding = new ItemStack(moving);
            adding.setAmount(slotAmount);
            ClickContext handledClick = GenericUIHandler.handleClick(ctx, nextSlot, type, action, null);
            if (handledClick != null) {
                if (handledClick.result() != ActionResult.PASS) {
                    result = handledClick.result();
                }
                if (handledClick.consumedItem()) {
                    event.setCursor(null);
                }
            }
            ++nextSlot;
        }
        return result;
    }

    @NotNull
    private static ActionResult handleShiftClick(@NotNull UIContext context, @NotNull InventoryClickEvent event, @NotNull Inventory top, @NotNull ClickType type, @NotNull InventoryAction action, @NotNull ActionResult result) {
        ItemStack moving = event.getCurrentItem();
        int remainingAmount = moving.getAmount();
        int nextSlot = GenericUIHandler.findNextEmptySlot(top, moving, 0);
        while (remainingAmount > 0 && nextSlot > -1 && result == ActionResult.PASS) {
            ItemStack item = top.getItem(nextSlot);
            int slotAmount = item == null || item.getType() == Material.AIR ? moving.getMaxStackSize() : item.getMaxStackSize() - item.getAmount();
            slotAmount = Math.min(slotAmount, remainingAmount);
            remainingAmount -= slotAmount;
            ItemStack adding = new ItemStack(moving);
            adding.setAmount(slotAmount);
            ClickContext handledClick = GenericUIHandler.handleClick(context, nextSlot, type, action, adding);
            if (handledClick != null) {
                if (handledClick.result() != ActionResult.PASS) {
                    result = handledClick.result();
                }
                if (handledClick.consumedItem()) {
                    event.setCursor(null);
                }
            }
            nextSlot = GenericUIHandler.findNextEmptySlot(top, moving, nextSlot + 1);
        }
        return result;
    }

    private static int findNextEmptySlot(@NotNull Inventory inventory, @NotNull ItemStack moving, int startIndex) {
        for (int i = startIndex; i < inventory.getSize(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (!moving.isSimilar(item) || item.getAmount() >= item.getMaxStackSize()) continue;
            return i;
        }
        return inventory.firstEmpty();
    }
}

