/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.ui.element.type;

import co.crystaldev.alpinecore.framework.config.object.item.DefinedConfigItem;
import co.crystaldev.alpinecore.framework.ui.UIContext;
import co.crystaldev.alpinecore.framework.ui.element.Element;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.commons.lang.Validate;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigItemElement
extends Element {
    private final DefinedConfigItem configItem;
    private final Object[] placeholders;
    private final OfflinePlayer primary;
    private final OfflinePlayer secondary;

    public ConfigItemElement(@NotNull UIContext context, @NotNull DefinedConfigItem configItem, @Nullable Object[] placeholders, @Nullable OfflinePlayer primary, @Nullable OfflinePlayer secondary) {
        super(context);
        this.configItem = configItem;
        this.placeholders = placeholders;
        this.primary = primary;
        this.secondary = secondary;
        Map<String, Object> attributes = configItem.getAttributes();
        if (attributes != null) {
            this.putAttributes(attributes);
        }
    }

    @Override
    @NotNull
    public ItemStack buildItemStack() {
        return this.configItem.build(this.context.plugin(), this.primary, this.secondary, this.placeholders);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DefinedConfigItem item;
        private final Map<String, Object> placeholders = new HashMap<String, Object>();
        private OfflinePlayer primary;
        private OfflinePlayer secondary;

        @NotNull
        public Builder type(@NotNull DefinedConfigItem item) {
            Validate.notNull((Object)item, (String)"item cannot be null");
            this.item = item;
            return this;
        }

        @NotNull
        public Builder placeholder(@NotNull String key, @NotNull Object value) {
            Validate.notNull((Object)key, (String)"key cannot be null");
            this.placeholders.put(key, value);
            return this;
        }

        @NotNull
        public Builder placeholder(@NotNull String key, @NotNull Supplier<?> value) {
            Validate.notNull((Object)key, (String)"key cannot be null");
            this.placeholders.put(key, value);
            return this;
        }

        @NotNull
        public Builder placeholders(Object ... placeholders) {
            Validate.notNull((Object)placeholders, (String)"placeholders cannot be null");
            Validate.isTrue((placeholders.length % 2 == 0 ? 1 : 0) != 0, (String)"placeholders must be even");
            for (int i = 0; i < placeholders.length / 2 * 2; i += 2) {
                String key = placeholders[i].toString();
                Object value = placeholders[i + 1];
                this.placeholders.put(key, value);
            }
            return this;
        }

        @NotNull
        public Builder placeholders(@NotNull Map<String, Object> placeholders) {
            this.placeholders.putAll(placeholders);
            return this;
        }

        @NotNull
        public Builder player(@Nullable OfflinePlayer player) {
            this.primary = player;
            return this;
        }

        @NotNull
        public Builder players(@Nullable OfflinePlayer primary, @Nullable OfflinePlayer secondary) {
            this.primary = primary;
            this.secondary = secondary;
            return this;
        }

        @NotNull
        public ConfigItemElement build(@NotNull UIContext context) {
            Object[] placeholders = new Object[this.placeholders.size() * 2];
            AtomicInteger index = new AtomicInteger();
            this.placeholders.forEach((key, value) -> {
                int i = index.get();
                placeholders[i] = key;
                placeholders[i + 1] = value;
                index.set(i + 2);
            });
            return new ConfigItemElement(context, this.item, placeholders, this.primary, this.secondary);
        }
    }
}

