/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.ui.element;

import co.crystaldev.alpinecore.util.Observable;
import lombok.Generated;
import lombok.NonNull;

public final class PaginatorState {
    private int elementCount;
    private int pageSize;
    private int maxPages;
    private final Observable<Integer> currentPage;

    public PaginatorState(int elementCount) {
        this.elementCount = elementCount;
        this.currentPage = Observable.of(0);
    }

    public PaginatorState(int elementCount, int page, int pageSize) {
        this.elementCount = elementCount;
        this.setPageSize(pageSize);
        this.currentPage = Observable.of(Math.max(0, Math.min(this.maxPages - 1, page)));
    }

    public void setElementCount(int elementCount) {
        this.elementCount = elementCount;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
        this.maxPages = pageSize == 0 ? 0 : (int)Math.ceil((double)this.elementCount / (double)pageSize);
    }

    public void resetPageSize() {
        this.pageSize = 0;
        this.maxPages = 0;
    }

    public void setPage(int page) {
        this.currentPage.set(Math.max(0, Math.min(this.maxPages - 1, page)));
    }

    public boolean isValid(int page) {
        return page >= 0 && page <= this.maxPages - 1;
    }

    @NonNull
    public Observable<Integer> pageObservable() {
        return this.currentPage;
    }

    public int getCurrentPage() {
        return this.currentPage.get();
    }

    @Generated
    public int getElementCount() {
        return this.elementCount;
    }

    @Generated
    public int getPageSize() {
        return this.pageSize;
    }

    @Generated
    public int getMaxPages() {
        return this.maxPages;
    }
}

