/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.ui.element;

import co.crystaldev.alpinecore.framework.ui.UIContext;
import co.crystaldev.alpinecore.framework.ui.element.Element;
import co.crystaldev.alpinecore.framework.ui.element.ElementPaginator;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import lombok.Generated;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ElementProvider<S, T extends Element> {
    @NotNull
    private final Collection<S> entries;
    private final BiFunction<UIContext, S, T> toElementFunction;
    private final Map<UIContext, State<S>> states = new HashMap<UIContext, State<S>>();

    private ElementProvider(@NotNull Collection<S> entries, @NotNull BiFunction<UIContext, S, T> toElementFunction) {
        this.entries = entries;
        this.toElementFunction = toElementFunction;
    }

    @Nullable
    public T nextElement(@NotNull UIContext context) {
        State state = this.states.computeIfAbsent(context, ctx -> new State<S>(this.entries.iterator()));
        Object next = state.next();
        return (T)(next != null ? (Element)this.toElementFunction.apply(context, next) : null);
    }

    @Nullable
    public T skipToIndex(@NotNull UIContext context, int index) {
        Validate.isTrue((index >= 0 && index < this.entries.size() ? 1 : 0) != 0, (String)"index out of bounds");
        State<S> state = new State<S>(this.entries.iterator());
        this.states.put(context, state);
        Object next = null;
        while (index-- > 0) {
            S s = state.next();
            next = s;
            if (s != null) continue;
        }
        return (T)(next != null ? (Element)this.toElementFunction.apply(context, next) : null);
    }

    @NotNull
    public T getElement(@NotNull UIContext context, int index) {
        Validate.isTrue((index >= 0 && index < this.entries.size() ? 1 : 0) != 0, (String)"index out of bounds");
        return (T)((Element)this.toElementFunction.apply(context, this.entries.stream().skip(index).findFirst().orElse(null)));
    }

    public int getIndex(@NotNull UIContext context) {
        State<S> state = this.states.get(context);
        return state == null ? -1 : ((State)state).index;
    }

    public int size() {
        return this.entries.size();
    }

    public void closed(@NotNull UIContext context) {
        this.states.entrySet().removeIf(e -> ((UIContext)e.getKey()).isStale() || ((UIContext)e.getKey()).playerId().equals(context.playerId()));
    }

    @NotNull
    public static <S, T extends Element> Builder<S, T> builder() {
        return new Builder();
    }

    @NotNull
    @Generated
    public Collection<S> getEntries() {
        return this.entries;
    }

    private static final class State<S> {
        private final Iterator<S> iterator;
        private int index;

        @Nullable
        public S next() {
            ++this.index;
            return this.iterator.hasNext() ? (S)this.iterator.next() : null;
        }

        @Generated
        public State(Iterator<S> iterator) {
            this.iterator = iterator;
        }
    }

    public static final class Builder<S, T extends Element> {
        private Collection<S> entries;
        private BiFunction<UIContext, S, T> toElementFunction;

        @NotNull
        public Builder<S, T> entries(@NotNull Collection<S> entries) {
            Validate.notNull(entries, (String)"entries cannot be null");
            this.entries = entries;
            return this;
        }

        @NotNull
        public Builder<S, T> entries(S ... entries) {
            Validate.notNull(entries, (String)"entries cannot be null");
            this.entries = ImmutableList.copyOf((Object[])entries);
            return this;
        }

        @NotNull
        public Builder<S, T> element(@NotNull BiFunction<UIContext, S, T> toElementFunction) {
            Validate.notNull(toElementFunction, (String)"toElementFunction cannot be null");
            this.toElementFunction = toElementFunction;
            return this;
        }

        @NotNull
        public ElementPaginator<S> createPaginator() {
            return ElementPaginator.from(this.build());
        }

        @NotNull
        public ElementProvider<S, T> build() {
            Validate.notNull(this.entries, (String)"entries cannot be null");
            Validate.notNull(this.toElementFunction, (String)"toElementFunction cannot be null");
            return new ElementProvider(this.entries, this.toElementFunction);
        }
    }
}

