/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.ui.element;

import co.crystaldev.alpinecore.framework.ui.SlotPosition;
import co.crystaldev.alpinecore.framework.ui.UIContext;
import co.crystaldev.alpinecore.framework.ui.element.type.EmptyElement;
import co.crystaldev.alpinecore.framework.ui.element.type.GenericElement;
import co.crystaldev.alpinecore.framework.ui.event.UIEventBus;
import co.crystaldev.alpinecore.framework.ui.event.UIEventSubscriber;
import co.crystaldev.alpinecore.framework.ui.interaction.ClickContext;
import co.crystaldev.alpinecore.framework.ui.interaction.ClickFunction;
import co.crystaldev.alpinecore.framework.ui.interaction.ClickProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Element
implements UIEventSubscriber {
    protected final UIContext context;
    protected SlotPosition position;
    protected Map<String, Object> attributes;
    protected ClickFunction onClick;
    protected ClickProperties clickProperties = ClickProperties.ALL_DISALLOWED;

    public Element(@NotNull UIContext context) {
        this.context = context;
    }

    @Nullable
    public abstract ItemStack buildItemStack();

    public boolean allowsEmptyItems() {
        return true;
    }

    public void init() {
    }

    public void closed() {
    }

    public void clicked(@NotNull ClickContext context) {
        if (this.onClick != null) {
            this.onClick.mouseClicked(this.context, context);
        }
    }

    @Nullable
    public <T> T getAttribute(@NotNull String key) {
        return (T)(this.attributes == null ? null : this.attributes.get(key));
    }

    public void setAttribute(@NotNull String key, @Nullable Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, value);
    }

    @NotNull
    public Map<String, Object> getAttributes() {
        return this.attributes == null ? Collections.emptyMap() : this.attributes;
    }

    public void putAttributes(@NotNull Map<String, Object> attributes) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.putAll(attributes);
    }

    @Override
    public void registerEvents(@NotNull UIEventBus bus) {
    }

    public static boolean isEmpty(@Nullable Element element) {
        return element == null || element instanceof EmptyElement;
    }

    @NotNull
    public static GenericElement of(@NotNull UIContext context, @NotNull ItemStack itemStack) {
        return new GenericElement(context, itemStack);
    }

    @NotNull
    public static Element fromNullable(@Nullable Element element) {
        return element == null ? Element.empty() : element;
    }

    @NotNull
    public static Element empty() {
        return EmptyElement.INSTANCE;
    }

    @Generated
    public SlotPosition getPosition() {
        return this.position;
    }

    @Generated
    public void setPosition(SlotPosition position) {
        this.position = position;
    }

    @Generated
    public void setOnClick(ClickFunction onClick) {
        this.onClick = onClick;
    }

    @Generated
    public ClickProperties getClickProperties() {
        return this.clickProperties;
    }

    @Generated
    public void setClickProperties(ClickProperties clickProperties) {
        this.clickProperties = clickProperties;
    }
}

