/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.ui;

import co.crystaldev.alpinecore.AlpinePlugin;
import co.crystaldev.alpinecore.framework.ui.GuiType;
import co.crystaldev.alpinecore.framework.ui.SlotPosition;
import co.crystaldev.alpinecore.framework.ui.UIContext;
import co.crystaldev.alpinecore.framework.ui.UIHolder;
import co.crystaldev.alpinecore.framework.ui.UIListener;
import co.crystaldev.alpinecore.framework.ui.UIState;
import co.crystaldev.alpinecore.framework.ui.element.Element;
import co.crystaldev.alpinecore.framework.ui.handler.UIHandler;
import co.crystaldev.alpinecore.framework.ui.type.ConfigInventoryUI;
import co.crystaldev.alpinecore.framework.ui.type.InventoryUI;
import co.crystaldev.alpinecore.util.Formatting;
import co.crystaldev.alpinecore.util.InventoryHelper;
import com.google.common.annotations.Beta;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Beta
public final class UIManager {
    private final AlpinePlugin plugin;
    private final Map<UUID, UIState> states = new ConcurrentHashMap<UUID, UIState>();

    public UIManager(@NotNull AlpinePlugin plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)new UIListener(this), (Plugin)plugin);
    }

    public void open(@NotNull Player player, @NotNull InventoryUI ui, boolean force) {
        UIState state = this.states.computeIfAbsent(player.getUniqueId(), k -> new UIState(player));
        if (!state.isEmpty() && state.peek().isProcessingInput()) {
            state.setAcceptInput(false);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.open(player, ui, force));
            return;
        }
        state.setAcceptInput(true);
        UIHolder holder = new UIHolder(state);
        ConfigInventoryUI properties = ui.getProperties();
        if (force) {
            while (!state.isEmpty()) {
                this.closeContext(state.pop());
            }
        }
        UUID id = player.getUniqueId();
        UIContext context = new UIContext(id, ui);
        holder.setContext(context);
        Object title = this.plugin.getMiniMessage().deserialize(Formatting.placeholders(this.plugin, properties.getName(), ui.getHandler().getTitlePlaceholders(context)));
        if (ui.getType() == GuiType.CHEST) {
            context.setInventory(InventoryHelper.createInventory((InventoryHolder)holder, properties.getSlots().length * 9, title));
        } else {
            context.setInventory(InventoryHelper.createInventory((InventoryHolder)holder, ui.getType().getInventoryType(), title));
        }
        UIContext lastContext = state.push(context);
        if (lastContext != null) {
            this.closeContext(lastContext);
        }
        this.open(player, context, true);
    }

    public void open(@NotNull Player player, @NotNull InventoryUI ui) {
        this.open(player, ui, false);
    }

    public void swap(@NotNull Player player, @NotNull InventoryUI ui) {
        UIState state = this.states.computeIfAbsent(player.getUniqueId(), k -> new UIState(player));
        if (!state.isEmpty()) {
            this.closeContext(state.pop());
        }
        this.open(player, ui, false);
    }

    public void close(@NotNull Player player, boolean openParent) {
        UUID playerId = player.getUniqueId();
        UIState state = this.states.get(playerId);
        if (!state.isEmpty() && state.peek().isProcessingInput()) {
            state.setAcceptInput(false);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.close(player, openParent));
            return;
        }
        state.setAcceptInput(true);
        this.closeContext(state.pop());
        if (!openParent || state.isEmpty()) {
            this.states.remove(playerId);
            while (!state.isEmpty()) {
                this.closeContext(state.pop());
            }
            player.closeInventory();
        } else {
            this.open(player, state.peek(), false);
        }
    }

    private void closeContext(@NotNull UIContext context) {
        this.closeContext(context, true);
    }

    private void closeContext(@NotNull UIContext context, boolean clearInventory) {
        context.ui().getHandler().closed(context);
        for (Element element : context.getElements()) {
            element.closed();
        }
        context.setStale(true);
        if (clearInventory && this.plugin.isEnabled()) {
            Inventory inventory = context.inventory();
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                inventory.clear();
                Player player = context.player();
                if (player != null && player.isOnline()) {
                    player.updateInventory();
                }
            }, 1L);
        }
    }

    void onClose(@NotNull Inventory inventory) {
        UIHolder holder = (UIHolder)inventory.getHolder();
        UIState state = holder.getState();
        Player player = state.getPlayer();
        if (!player.isOnline() || state.isEmpty()) {
            this.states.remove(player.getUniqueId());
            return;
        }
        UIContext context = holder.getContext();
        if (context.equals(state.peek())) {
            UIHandler handler = context.ui().getHandler();
            this.close(player, handler.openParentOnClose(context));
        }
    }

    void onTick(long tick) {
        if (this.states.isEmpty()) {
            return;
        }
        this.states.forEach((playerId, state) -> {
            Player player = Bukkit.getPlayer((UUID)playerId);
            if (player != null && !state.isEmpty()) {
                UIContext context = state.peek();
                UIHandler handler = context.ui().getHandler();
                handler.tick(context);
            }
        });
    }

    @Nullable
    public UIContext get(@NotNull UUID player) {
        return Optional.ofNullable(this.states.get(player)).map(UIState::peek).orElse(null);
    }

    @Nullable
    public UIContext get(@NotNull Player player) {
        return this.get(player.getUniqueId());
    }

    public boolean has(@NotNull UUID player) {
        return this.states.containsKey(player);
    }

    public boolean has(@NotNull Player player) {
        return this.get(player) != null;
    }

    public void rebuild(@NotNull UIContext context) {
        this.closeContext(context, false);
        context.ui().getHandler().fill(context);
        this.refresh(context);
    }

    public void refresh(@NotNull UIContext context) {
        UIHandler handler = context.ui().getHandler();
        handler.beforeRefresh(context);
        Inventory inventory = context.inventory();
        inventory.clear();
        for (Element element : context.getElements()) {
            SlotPosition position = element.getPosition();
            if (position == null) continue;
            element.init();
            ItemStack item = element.buildItemStack();
            if (item == null && !element.allowsEmptyItems()) continue;
            inventory.setItem(position.getSlot(), item);
        }
        handler.afterRefresh(context);
        Player player = context.player();
        InventoryView openInventory = player.getOpenInventory();
        if (openInventory != null && openInventory.getTopInventory().equals((Object)inventory)) {
            player.updateInventory();
        }
    }

    private void open(@NotNull Player player, @NotNull UIContext context, boolean initialize) {
        UIHandler handler = context.ui().getHandler();
        if (initialize) {
            handler.registerEvents(context.eventBus());
        }
        context.setStale(false);
        handler.init(context);
        handler.fill(context);
        this.refresh(context);
        Bukkit.getScheduler().runTask((Plugin)context.plugin(), () -> player.openInventory(context.inventory()));
    }

    @ApiStatus.Internal
    public void closeAll() {
        this.states.keySet().forEach(playerId -> {
            Player player = Bukkit.getPlayer((UUID)playerId);
            if (player != null) {
                this.close(player, false);
            }
        });
    }

    boolean isManaged(@NotNull Inventory inventory) {
        InventoryHolder inventoryHolder = inventory.getHolder();
        if (!(inventoryHolder instanceof UIHolder)) {
            return false;
        }
        UIHolder holder = (UIHolder)inventoryHolder;
        UIState state = this.states.get(holder.getPlayer().getUniqueId());
        return state != null && holder.getContext().equals(state.peek());
    }

    boolean canInteract(@NotNull UUID player) {
        UIState state = this.states.get(player);
        return state == null || state.isAcceptInput();
    }

    @Generated
    public AlpinePlugin getPlugin() {
        return this.plugin;
    }
}

