/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.ui;

import co.crystaldev.alpinecore.AlpinePlugin;
import co.crystaldev.alpinecore.framework.ui.SlotPosition;
import co.crystaldev.alpinecore.framework.ui.UIManager;
import co.crystaldev.alpinecore.framework.ui.element.Element;
import co.crystaldev.alpinecore.framework.ui.event.UIEventBus;
import co.crystaldev.alpinecore.framework.ui.type.InventoryUI;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class UIContext {
    private final UUID playerId;
    private final InventoryUI ui;
    private final UIEventBus eventBus = new UIEventBus();
    private final List<Element> elements = new LinkedList<Element>();
    private boolean stale;
    private boolean processingInput;
    private Inventory inventory;

    UIContext(@NotNull UUID playerId, @NotNull InventoryUI ui) {
        this.playerId = playerId;
        this.ui = ui;
    }

    @NotNull
    public UIManager manager() {
        return this.ui.getManager();
    }

    @NotNull
    public AlpinePlugin plugin() {
        return this.manager().getPlugin();
    }

    @NotNull
    public UIEventBus eventBus() {
        return this.eventBus;
    }

    @NotNull
    public UUID playerId() {
        return this.playerId;
    }

    @NotNull
    public Player player() {
        return Bukkit.getPlayer((UUID)this.playerId);
    }

    @NotNull
    public InventoryUI ui() {
        return this.ui;
    }

    @NotNull
    public Inventory inventory() {
        return this.inventory;
    }

    @NotNull
    public ItemStack getItem(int slot) {
        return this.inventory.getItem(slot);
    }

    @NotNull
    public ItemStack getItem(@NotNull SlotPosition slot) {
        return this.inventory.getItem(slot.getSlot());
    }

    @NotNull
    public ItemStack getItem(@NotNull Element element) {
        return this.inventory.getItem(element.getPosition().getSlot());
    }

    public void rebuild() {
        this.manager().rebuild(this);
    }

    public void refresh() {
        this.manager().refresh(this);
    }

    public void close(boolean openParent) {
        this.manager().close(this.player(), openParent);
    }

    public void addElement(@NotNull Element element) {
        element.registerEvents(this.eventBus);
        this.elements.add(element);
    }

    public void removeElement(@NotNull Element element) {
        this.eventBus.unregister(element);
        this.elements.remove(element);
    }

    public void clearElements() {
        for (Element element : this.elements) {
            this.eventBus.unregister(element);
        }
        this.elements.clear();
    }

    public void removeElement(int slot) {
        this.elements.removeIf(element -> {
            SlotPosition position = element.getPosition();
            if (position != null && position.getSlot() == slot) {
                this.eventBus.unregister(element);
                return true;
            }
            return false;
        });
    }

    @Generated
    public List<Element> getElements() {
        return this.elements;
    }

    @Generated
    public boolean isStale() {
        return this.stale;
    }

    @Generated
    void setStale(boolean stale) {
        this.stale = stale;
    }

    @Generated
    boolean isProcessingInput() {
        return this.processingInput;
    }

    @Generated
    void setProcessingInput(boolean processingInput) {
        this.processingInput = processingInput;
    }

    @Generated
    void setInventory(Inventory inventory) {
        this.inventory = inventory;
    }
}

