/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.ui;

import lombok.Generated;
import org.bukkit.event.inventory.InventoryType;
import org.jetbrains.annotations.NotNull;

public enum GuiType {
    CHEST(InventoryType.CHEST, 9, 1, 6),
    HOPPER(InventoryType.HOPPER, 5, 1, 1),
    DISPENSER(InventoryType.DISPENSER, 3, 3, 3);

    private final InventoryType inventoryType;
    private final int rowLength;
    private final int minHeight;
    private final int maxHeight;

    private boolean fits(String[] slots) {
        if (slots.length > this.maxHeight || slots.length < this.minHeight) {
            return false;
        }
        for (String row : slots) {
            if (row.length() <= this.rowLength) continue;
            return false;
        }
        return true;
    }

    private int waste(@NotNull String[] slots) {
        int excessRows = Math.max(0, this.getMaxHeight() - slots.length);
        int deficientRows = Math.max(0, slots.length - this.getMinHeight());
        return excessRows + deficientRows;
    }

    @NotNull
    public static GuiType resolveType(@NotNull String[] slots) {
        GuiType bestMatch = null;
        int minWaste = Integer.MAX_VALUE;
        for (GuiType type : GuiType.values()) {
            int currentWaste;
            if (!type.fits(slots) || (currentWaste = type.waste(slots)) >= minWaste) continue;
            minWaste = currentWaste;
            bestMatch = type;
        }
        return bestMatch != null ? bestMatch : CHEST;
    }

    @NotNull
    public static GuiType fromType(@NotNull InventoryType inventoryType) {
        for (GuiType type : GuiType.values()) {
            if (type.inventoryType != inventoryType) continue;
            return type;
        }
        return CHEST;
    }

    @Generated
    private GuiType(InventoryType inventoryType, int rowLength, int minHeight, int maxHeight) {
        this.inventoryType = inventoryType;
        this.rowLength = rowLength;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
    }

    @Generated
    public InventoryType getInventoryType() {
        return this.inventoryType;
    }

    @Generated
    public int getRowLength() {
        return this.rowLength;
    }

    @Generated
    public int getMinHeight() {
        return this.minHeight;
    }

    @Generated
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Generated
    public String toString() {
        return "GuiType." + this.name() + "(inventoryType=" + this.getInventoryType() + ", rowLength=" + this.getRowLength() + ", minHeight=" + this.getMinHeight() + ", maxHeight=" + this.getMaxHeight() + ")";
    }
}

