/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.storage;

import co.crystaldev.alpinecore.util.UuidTypeAdapter;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public interface KeySerializer<T1, T2> {
    public T2 serialize(T1 var1);

    public T1 deserialize(T2 var1);

    public static final class PlayerKey
    implements KeySerializer<OfflinePlayer, String> {
        @Override
        public String serialize(OfflinePlayer input) {
            return UuidTypeAdapter.fromUUID(input.getUniqueId());
        }

        @Override
        public OfflinePlayer deserialize(String input) {
            UUID id = UuidTypeAdapter.fromString(input);
            return Bukkit.getServer().getOfflinePlayer(id);
        }
    }

    public static final class UuidKey
    implements KeySerializer<UUID, String> {
        @Override
        public String serialize(UUID input) {
            return UuidTypeAdapter.fromUUID(input);
        }

        @Override
        public UUID deserialize(String input) {
            return UuidTypeAdapter.fromString(input);
        }
    }

    public static final class StringKey
    implements KeySerializer<String, String> {
        @Override
        public String serialize(String input) {
            return input;
        }

        @Override
        public String deserialize(String input) {
            return input;
        }
    }

    public static final class NumberKey
    implements KeySerializer<Number, Long> {
        @Override
        public Long serialize(Number input) {
            return input.longValue();
        }

        @Override
        public Number deserialize(Long input) {
            return input;
        }
    }
}

