/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.storage;

import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class CachingStrategy {
    private final long maximumSize;
    private final long expireTimeValue;
    private final TimeUnit expireTimeUnit;
    private final int concurrencyLevel;

    private CachingStrategy(long maximumSize, long expireTimeValue, @NotNull TimeUnit expireTimeUnit, int concurrencyLevel) {
        this.maximumSize = maximumSize;
        this.expireTimeValue = expireTimeValue;
        this.expireTimeUnit = expireTimeUnit;
        this.concurrencyLevel = concurrencyLevel;
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public long getMaximumSize() {
        return this.maximumSize;
    }

    @Generated
    public long getExpireTimeValue() {
        return this.expireTimeValue;
    }

    @Generated
    public TimeUnit getExpireTimeUnit() {
        return this.expireTimeUnit;
    }

    @Generated
    public int getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    public static final class Builder {
        private long maximumSize = 100L;
        private long expireTimeValue = 30L;
        private TimeUnit expireTimeUnit = TimeUnit.MINUTES;
        private int concurrencyLevel = 1;

        @Contract(value="_ -> this")
        @NotNull
        public Builder maximumSize(long maximumSize) {
            Validate.isTrue((maximumSize >= -1L ? 1 : 0) != 0);
            this.maximumSize = maximumSize;
            return this;
        }

        @Contract(value="_, _ -> this")
        @NotNull
        public Builder expireTime(long expireTimeValue, TimeUnit expireTimeUnit) {
            return this.expireTimeValue(expireTimeValue).expireTimeUnit(expireTimeUnit);
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder expireTimeValue(long expireTimeValue) {
            Validate.isTrue((this.expireTimeValue > 0L ? 1 : 0) != 0);
            this.expireTimeValue = expireTimeValue;
            return this;
        }

        @Contract(value="null -> fail; _ -> this")
        @NotNull
        public Builder expireTimeUnit(TimeUnit expireTimeUnit) {
            Validate.notNull((Object)((Object)this.expireTimeUnit));
            this.expireTimeUnit = expireTimeUnit;
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder concurrencyLevel(int concurrencyLevel) {
            Validate.isTrue((this.concurrencyLevel > 0 ? 1 : 0) != 0);
            this.concurrencyLevel = concurrencyLevel;
            return this;
        }

        @NotNull
        public CachingStrategy build() {
            return new CachingStrategy(this.maximumSize, this.expireTimeValue, this.expireTimeUnit, this.concurrencyLevel);
        }
    }
}

