/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.storage;

import co.crystaldev.alpinecore.AlpinePlugin;
import co.crystaldev.alpinecore.framework.Activatable;
import co.crystaldev.alpinecore.framework.storage.CachingStrategy;
import co.crystaldev.alpinecore.framework.storage.driver.AlpineDriver;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class AlpineStore<K, D>
implements Activatable {
    private static final long PERSIST_TASK_PERIOD = 3600L;
    protected final AlpinePlugin plugin;
    private final AlpineDriver<K, D> driver;
    private final LoadingCache<K, D> readCache;
    private final Map<K, D> writeCache;
    private int taskId;

    protected AlpineStore(AlpinePlugin plugin, AlpineDriver<K, D> driver) {
        this(plugin, driver, CachingStrategy.builder().build());
    }

    protected AlpineStore(AlpinePlugin plugin, AlpineDriver<K, D> driver, CachingStrategy strategy) {
        this.plugin = plugin;
        this.driver = driver;
        this.readCache = CacheBuilder.newBuilder().maximumSize(strategy.getMaximumSize()).expireAfterAccess(strategy.getExpireTimeValue(), strategy.getExpireTimeUnit()).concurrencyLevel(strategy.getConcurrencyLevel()).build(new CacheLoader<K, D>(){

            @NotNull
            public D load(@NotNull K key) throws Exception {
                if (AlpineStore.this.writeCache.containsKey(key)) {
                    return AlpineStore.this.writeCache.get(key);
                }
                return AlpineStore.this.driver.retrieveEntry(key);
            }
        });
        this.writeCache = new HashMap<K, D>();
    }

    @Nullable
    public final D get(@NotNull K key) {
        try {
            return (D)this.readCache.get(key);
        }
        catch (Throwable t) {
            this.plugin.log(String.format("Error getting value for key %s", key), t);
            return null;
        }
    }

    @NotNull
    public final D getOrCreate(@NotNull K key, @NotNull D defaultData) {
        D data;
        if (!this.has(key)) {
            this.put(key, defaultData);
        }
        if ((data = this.get(key)) != null) {
            return data;
        }
        throw new IllegalStateException();
    }

    @NotNull
    public final D getOrCreate(@NotNull K key, @NotNull Supplier<D> defaultDataSupplier) {
        D data;
        if (!this.has(key)) {
            this.put(key, defaultDataSupplier.get());
        }
        if ((data = this.get(key)) != null) {
            return data;
        }
        throw new IllegalStateException();
    }

    @NotNull
    public final Collection<D> loadAllEntries() throws Exception {
        return this.driver.getAllEntries();
    }

    @NotNull
    public final Collection<D> loadAllEntries(@Nullable Consumer<Exception> exceptionHandler) {
        return this.driver.getAllEntries(exceptionHandler);
    }

    public final boolean has(@NotNull K key) {
        if (this.writeCache.containsKey(key)) {
            return true;
        }
        if (this.readCache.asMap().containsKey(key)) {
            return true;
        }
        return this.driver.hasEntry(key);
    }

    public final boolean remove(@NotNull K key) {
        this.writeCache.remove(key);
        this.readCache.invalidate(key);
        return this.driver.deleteEntry(key);
    }

    public final void put(@NotNull K key, @NotNull D data) {
        this.writeCache.put(key, data);
        this.readCache.refresh(key);
    }

    public boolean flush() {
        boolean success = true;
        if (!this.driver.persistEntries(this.writeCache)) {
            this.plugin.log(Level.SEVERE, String.format("&cError persisting value in %s", this.getClass().getSimpleName()));
            success = false;
        }
        this.writeCache.clear();
        return success;
    }

    public boolean flush(@NotNull K key) {
        D value = this.writeCache.remove(key);
        if (value == null) {
            return false;
        }
        boolean success = true;
        if (!this.driver.persistEntry(key, value)) {
            this.plugin.log(Level.SEVERE, String.format("&cError persisting value \"%s\" in %s", key, this.getClass().getSimpleName()));
            success = false;
        }
        return success;
    }

    @Override
    public final void activate(@NotNull AlpinePlugin context) {
        this.taskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, this::flush, 1L, 3600L);
        if (this.taskId != -1) {
            this.plugin.log(String.format("&aStore activated &d%s", this.getClass().getSimpleName()));
        } else {
            this.plugin.log(Level.SEVERE, String.format("&cError activating &d%s", this.getClass().getSimpleName()));
        }
    }

    @Override
    public final void deactivate(@NotNull AlpinePlugin context) {
        Bukkit.getScheduler().cancelTask(this.taskId);
        this.flush();
        this.driver.shutdown();
        this.readCache.invalidateAll();
        this.taskId = -1;
        this.plugin.log(String.format("&cStore deactivated &d%s", this.getClass().getSimpleName()));
    }

    @Override
    public final boolean isActive() {
        return this.taskId != -1;
    }
}

