/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.config.object.item;

import co.crystaldev.alpinecore.util.ReflectionHelper;
import com.cryptomorin.xseries.XEnchantment;
import com.cryptomorin.xseries.XItemFlag;
import com.cryptomorin.xseries.XPotion;
import com.cryptomorin.xseries.base.XBase;
import com.cryptomorin.xseries.profiles.builder.XSkull;
import com.cryptomorin.xseries.profiles.objects.Profileable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;

final class ConfigItemHelper {
    private static final Map<String, XEnchantment> ENCHANTMENTS = new HashMap<String, XEnchantment>();
    private static final Map<String, XItemFlag> FLAGS = new HashMap<String, XItemFlag>();
    private static final Map<String, XPotion> POTIONS = new HashMap<String, XPotion>();
    private static final Method PotionMeta$setBasePotionType = ReflectionHelper.findMethod(PotionMeta.class, "setBasePotionType", PotionType.class);
    private static final Class<?> PotionData = ReflectionHelper.getClass(Bukkit.class.getClassLoader(), "org.bukkit.potion.PotionData");
    private static final Constructor<?> PotionData$init = PotionData == null ? null : ReflectionHelper.findConstructor(PotionData, PotionType.class);
    private static final Method PotionMeta$setBasePotionData = PotionData == null ? null : ReflectionHelper.findMethod(PotionMeta.class, "setBasePotionData", PotionData);
    private static final Method PotionMeta$setColor = ReflectionHelper.findMethod(PotionMeta.class, "setColor", Color.class);

    ConfigItemHelper() {
    }

    public static void applyToItem(@NotNull ItemStack itemStack, @NotNull Map<String, Object> attributes) {
        ENCHANTMENTS.forEach((key, enchantment) -> {
            Object attrib = attributes.get(key);
            if (attrib == null) {
                return;
            }
            itemStack.addUnsafeEnchantment((Enchantment)enchantment.get(), Integer.parseInt(attrib.toString()));
        });
        ItemMeta itemMeta = itemStack.getItemMeta();
        FLAGS.forEach((key, flag) -> {
            Object attrib = attributes.get(key);
            if (attrib == null || "false".equals(attributes.getOrDefault(key, "false").toString())) {
                return;
            }
            itemMeta.addItemFlags(new ItemFlag[]{flag.get()});
        });
        if (itemMeta instanceof PotionMeta) {
            Object primaryEffect;
            POTIONS.forEach((key, potion) -> {
                int duration;
                Object attrib = attributes.get(key);
                if (attrib == null) {
                    return;
                }
                int amplifier = 0;
                if (attrib instanceof Number) {
                    duration = ((Number)attrib).intValue();
                } else if (attrib instanceof Map) {
                    Map effect = (Map)attrib;
                    duration = effect.getOrDefault("duration", 0);
                    amplifier = effect.getOrDefault("amplifier", 0);
                } else {
                    String[] split = attrib.toString().split(" ");
                    duration = Integer.parseInt(split[0]);
                    if (split.length > 1) {
                        amplifier = Integer.parseInt(split[1]);
                    }
                }
                PotionMeta potionMeta = (PotionMeta)itemMeta;
                potionMeta.addCustomEffect(potion.buildPotionEffect(duration * 20, amplifier), true);
                ConfigItemHelper.setPrimaryType(potionMeta, potion);
            });
            Object potionColor = attributes.get("potion_color");
            if (potionColor != null && PotionMeta$setColor != null) {
                int color = 0;
                if (potionColor instanceof Number) {
                    color = ((Number)potionColor).intValue();
                } else if (potionColor instanceof String) {
                    color = Integer.parseInt(potionColor.toString(), 16);
                }
                ReflectionHelper.invokeMethod(PotionMeta$setColor, itemMeta, Color.fromRGB((int)color));
            }
            if ((primaryEffect = attributes.get("primary_effect")) != null) {
                XPotion.matchXPotion((String)primaryEffect).ifPresent(potion -> {
                    if (!potion.isSupported()) {
                        return;
                    }
                    ConfigItemHelper.setPrimaryType((PotionMeta)itemMeta, potion);
                });
            }
            if ("true".equals(attributes.getOrDefault("hide_effects", "false").toString())) {
                itemMeta.addItemFlags(new ItemFlag[]{XItemFlag.HIDE_ADDITIONAL_TOOLTIP.get()});
            }
        }
        if (itemMeta instanceof SkullMeta && attributes.containsKey("skull_profile")) {
            Profileable profileable = Profileable.detect(attributes.get("skull_profile").toString());
            XSkull.of(itemMeta).profile(profileable).apply();
        }
        itemStack.setItemMeta(itemMeta);
    }

    private static void setPrimaryType(@NotNull PotionMeta meta, @NotNull XPotion type) {
        if (PotionMeta$setBasePotionType != null) {
            ReflectionHelper.invokeMethod(PotionMeta$setBasePotionType, meta, type.getPotionType());
        } else if (PotionMeta$setBasePotionData != null && PotionData$init != null) {
            Object potionData = ReflectionHelper.invokeConstructor(PotionData$init, type.getPotionType());
            ReflectionHelper.invokeMethod(PotionMeta$setBasePotionData, meta, potionData);
        } else {
            meta.setMainEffect(type.getPotionEffectType());
        }
    }

    static {
        for (XEnchantment xEnchantment : XEnchantment.values()) {
            if (!xEnchantment.isSupported()) continue;
            ENCHANTMENTS.put("enchant_" + xEnchantment.name().toLowerCase(), xEnchantment);
        }
        for (XBase<XEnchantment, Enchantment> xBase : XPotion.values()) {
            if (!xBase.isSupported()) continue;
            POTIONS.put("potion_" + ((Enum)((Object)xBase)).name().toLowerCase(), (XPotion)xBase);
        }
        for (XBase<XEnchantment, Enchantment> xBase : XItemFlag.values()) {
            if (!xBase.isSupported()) continue;
            FLAGS.put("flag_" + ((Enum)((Object)xBase)).name().toLowerCase(), (XItemFlag)xBase);
        }
    }
}

