/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.config.object.item;

import co.crystaldev.alpinecore.framework.config.object.item.ConfigItem;
import co.crystaldev.alpinecore.framework.config.object.item.DefinedConfigItem;
import co.crystaldev.alpinecore.framework.config.object.item.VaryingConfigItem;
import com.cryptomorin.xseries.XMaterial;
import de.exlll.configlib.Serializer;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

abstract class ConfigItemAdapter
implements Serializer<ConfigItem, Map<String, Object>> {
    ConfigItemAdapter() {
    }

    public abstract boolean requiresType();

    @Override
    public Map<String, Object> serialize(ConfigItem element) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (element instanceof DefinedConfigItem) {
            result.put("type", ((DefinedConfigItem)element).getType().name());
        }
        result.put("name", element.getName());
        if (element.getLore() != null && !element.getLore().isEmpty()) {
            result.put("lore", element.getLore());
        }
        if (element.isEnchanted()) {
            result.put("enchanted", element.isEnchanted());
        }
        if (element.getCount() > 0) {
            result.put("count", element.getCount());
        }
        if (element.getAttributes() != null && !element.getAttributes().isEmpty()) {
            result.put("attributes", element.getAttributes());
        }
        return result;
    }

    @Override
    public ConfigItem deserialize(Map<String, Object> element) {
        Object type = element.get("type");
        if (type != null) {
            type = XMaterial.matchXMaterial(type.toString()).orElse(null);
        }
        String name = element.getOrDefault("name", "").toString();
        List<String> lore = element.getOrDefault("lore", Collections.emptyList());
        if (!(lore instanceof List)) {
            lore = new LinkedList<String>(Arrays.asList(lore.toString().split("[\r\n]|<br>")));
        }
        int count = (Integer)element.getOrDefault("count", -1);
        boolean enchanted = element.getOrDefault("enchanted", "false").toString().equalsIgnoreCase("true");
        Object attributes = element.get("attributes");
        if (!(attributes instanceof Map)) {
            attributes = null;
        }
        if (this.requiresType() || type != null) {
            return new DefinedConfigItem((XMaterial)type, name, lore, count, enchanted, (Map)attributes);
        }
        return new VaryingConfigItem(name, lore, count, enchanted, (Map)attributes);
    }
}

